/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.babyfish.jimmer.jackson.PropDeserializeUtils;
import org.babyfish.jimmer.jackson.PropNameConverter;
import org.babyfish.jimmer.jackson.meta.BeanProps;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;

public class ImmutableDeserializer
extends StdDeserializer<Object> {
    private final ImmutableType immutableType;
    private final PropNameConverter propNameConverter;

    public ImmutableDeserializer(ImmutableType immutableType, PropNameConverter propNameConverter) {
        super(immutableType.getJavaClass());
        this.immutableType = immutableType;
        this.propNameConverter = propNameConverter;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return Internal.produce(this.immutableType, null, draft -> {
            for (ImmutableProp prop : this.immutableType.getProps().values()) {
                if (prop.getPropsDependOnSelf().isEmpty()) continue;
                ((DraftSpi)draft).__show(prop.getId(), false);
            }
            for (ImmutableProp prop : this.immutableType.getProps().values()) {
                if (!prop.isMutable()) continue;
                String fieldName = this.propNameConverter.fieldName(prop);
                String nodeName = null;
                if (node.has(fieldName)) {
                    nodeName = fieldName;
                } else {
                    for (String alias : this.propNameConverter.aliases(prop)) {
                        if (!node.has(alias)) continue;
                        nodeName = alias;
                        break;
                    }
                }
                if (nodeName == null) continue;
                Object value = PropDeserializeUtils.readTreeAsValue(ctx, node.get(nodeName), (BeanProperty)BeanProps.get(ctx.getTypeFactory(), prop));
                if (value != null && prop.getConverter() != null) {
                    value = prop.getConverter().input(value);
                }
                ((DraftSpi)draft).__set(prop.getId(), value);
                ((DraftSpi)draft).__show(prop.getId(), true);
            }
        });
    }
}

