/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.error.ErrorDebugInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportedError {
    private final String family;
    private final String code;
    private final Map<String, Object> fields;
    private final ErrorDebugInfo debugInfo;

    @JsonCreator
    public ExportedError(@JsonProperty(value="family", required=true) @NotNull String family, @JsonProperty(value="code", required=true) @NotNull String code, @JsonProperty(value="fields", required=true) @NotNull Map<String, Object> fields, @JsonProperty(value="debugInfo", required=false) ErrorDebugInfo debugInfo) {
        this.family = Objects.requireNonNull(family, "`family` cannot be null");
        this.code = Objects.requireNonNull(code, "`code` cannot be null");
        this.fields = Objects.requireNonNull(fields, "`fields` cannot be null");
        this.debugInfo = debugInfo;
    }

    @NotNull
    public String getFamily() {
        return this.family;
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @NotNull
    public Map<String, Object> getFields() {
        return this.fields;
    }

    @Nullable
    public ErrorDebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportedError that = (ExportedError)o;
        return this.family.equals(that.family) && this.code.equals(that.code) && this.fields.equals(that.fields) && Objects.equals(this.debugInfo, that.debugInfo);
    }

    public int hashCode() {
        return Objects.hash(this.family, this.code, this.fields, this.debugInfo);
    }

    public String toString() {
        return "ExportedError{family='" + this.family + '\'' + ", code='" + this.code + '\'' + ", fields=" + this.fields + ", debugInfo=" + this.debugInfo + '}';
    }
}

