/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.error;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDebugInfo {
    private final String message;
    private final String stackTrace;
    private final ErrorDebugInfo causeBy;

    public ErrorDebugInfo(@JsonProperty(value="family", required=false) @Nullable String message, @JsonProperty(value="family", required=true) @NotNull String stackTrace, @JsonProperty(value="family", required=false) @Nullable ErrorDebugInfo causeBy) {
        this.message = message;
        this.stackTrace = Objects.requireNonNull(stackTrace, "`stackTrace` cannot be null");
        this.causeBy = causeBy;
    }

    @Nullable
    public static ErrorDebugInfo of(@Nullable Throwable ex) {
        ErrorDebugInfo causeBy = ErrorDebugInfo.of(ex.getCause());
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : ex.getStackTrace()) {
            builder.append(element.toString()).append('\n');
        }
        return new ErrorDebugInfo(ex.getMessage(), builder.toString(), causeBy);
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @NotNull
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Nullable
    public ErrorDebugInfo getCauseBy() {
        return this.causeBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorDebugInfo that = (ErrorDebugInfo)o;
        return Objects.equals(this.message, that.message) && this.stackTrace.equals(that.stackTrace) && Objects.equals(this.causeBy, that.causeBy);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.stackTrace, this.causeBy);
    }

    public String toString() {
        return "ErrorDebugInfo{message='" + this.message + '\'' + ", stackTrace='" + this.stackTrace + '\'' + ", causeBy=" + this.causeBy + '}';
    }
}

