/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.sql.meta.MultipleColumns;

public class EmbeddedColumns
extends MultipleColumns {
    private static final String[] EMPTY_ARR = new String[0];
    private final Map<String, Partial> partialMap;

    public EmbeddedColumns(Map<String, PathData> pathDataMap) {
        super(pathDataMap.get((Object)"").columnNames.toArray(EMPTY_ARR), true);
        HashMap<String, Partial> map = new HashMap<String, Partial>();
        for (Map.Entry<String, PathData> e : pathDataMap.entrySet()) {
            String key = e.getKey();
            PathData pathData = e.getValue();
            map.put(key, new Partial(key, pathData.columnNames, pathData.isTerminal));
        }
        this.partialMap = map;
    }

    public Partial partial(String path) {
        Partial partial;
        if (path == null) {
            path = "";
        }
        if ((partial = this.partialMap.get(path)) == null) {
            throw new IllegalArgumentException("Illegal embedded path \"" + path + "\"");
        }
        return partial;
    }

    public Map<String, Partial> getPartialMap() {
        return Collections.unmodifiableMap(this.partialMap);
    }

    public static class PathData {
        public final boolean isTerminal;
        public final List<String> columnNames = new ArrayList<String>();

        public PathData(boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public String toString() {
            return (this.isTerminal ? "column" : "embedded") + this.columnNames;
        }
    }

    public static class Partial
    extends MultipleColumns {
        private final String path;

        Partial(String path, List<String> columns, boolean isTerminal) {
            super(columns.toArray(EMPTY_ARR), !isTerminal);
            this.path = path;
        }

        public String path() {
            return this.path;
        }
    }
}

