/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kotlin.jvm.internal.ClassBasedDeclarationContainer;
import kotlin.reflect.KClass;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.meta.impl.ImmutablePropImpl;
import org.babyfish.jimmer.meta.impl.PropChains;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.GeneratedValue;
import org.babyfish.jimmer.sql.GenerationType;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.Table;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.SequenceIdGenerator;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableTypeImpl
implements ImmutableType {
    private static final Class<? extends Annotation>[] SQL_ANNOTATION_TYPES = new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class};
    private final Class<?> javaClass;
    private final boolean isEntity;
    private final boolean isMappedSupperClass;
    private final boolean isEmbeddable;
    private final Annotation immutableAnnotation;
    private KClass<?> kotlinClass;
    private final ImmutableType superType;
    private final BiFunction<DraftContext, Object, Draft> draftFactory;
    private Map<String, ImmutableProp> declaredProps;
    private Map<String, ImmutableProp> props;
    private ImmutableProp[] propArr;
    private Map<String, List<ImmutableProp>> chainMap;
    private Map<String, ImmutableProp> selectableProps;
    private Map<String, ImmutableProp> selectableReferenceProps;
    private ImmutableProp idProp;
    private ImmutableProp versionProp;
    private LogicalDeletedInfo declaredLogicalDeletedInfo;
    private Set<ImmutableProp> keyProps = Collections.emptySet();
    private IdGenerator idGenerator;
    private String tableName;

    ImmutableTypeImpl(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        Table table;
        Annotation sqlAnnotation = null;
        for (Class<? extends Annotation> sqlAnnotationType : SQL_ANNOTATION_TYPES) {
            Annotation anno = javaClass.getAnnotation(sqlAnnotationType);
            if (anno == null) continue;
            if (sqlAnnotation != null) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", it cannot be decorated by both @" + sqlAnnotation.annotationType().getName() + " and @" + anno.annotationType().getName());
            }
            sqlAnnotation = anno;
        }
        if (sqlAnnotation != null) {
            this.immutableAnnotation = sqlAnnotation;
        } else {
            this.immutableAnnotation = javaClass.getAnnotation(Immutable.class);
            if (this.immutableAnnotation == null) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", it is not immutable type");
            }
        }
        this.javaClass = javaClass;
        this.superType = superType;
        this.draftFactory = draftFactory;
        this.isEntity = this.immutableAnnotation instanceof Entity;
        this.isMappedSupperClass = this.immutableAnnotation instanceof MappedSuperclass;
        this.isEmbeddable = this.immutableAnnotation instanceof Embeddable;
        if (superType != null) {
            if ((this.isEntity || this.isMappedSupperClass) && !superType.isMappedSuperclass()) {
                throw new ModelException("Illegal immutable type \"" + this + "\", the super type \"" + superType + "\" is not decorated by @" + MappedSuperclass.class.getName());
            }
            if ((superType.isEntity() || superType.isMappedSuperclass()) && !this.isEntity && !this.isMappedSupperClass) {
                throw new ModelException("Illegal immutable type \"" + this + "\", it has super type because it is decorated by neither @" + Entity.class.getName() + " nor @" + MappedSuperclass.class.getName());
            }
        }
        String string = this.tableName = (table = javaClass.getAnnotation(Table.class)) != null ? table.name() : "";
        if (this.tableName.isEmpty()) {
            this.tableName = DatabaseIdentifiers.databaseIdentifier(javaClass.getSimpleName());
        }
    }

    ImmutableTypeImpl(KClass<?> kotlinClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        this(((ClassBasedDeclarationContainer)kotlinClass).getJClass(), superType, draftFactory);
        this.kotlinClass = kotlinClass;
    }

    @Override
    @NotNull
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isKotlinClass() {
        return this.kotlinClass != null;
    }

    @Override
    public boolean isEntity() {
        return this.isEntity;
    }

    @Override
    public boolean isMappedSuperclass() {
        return this.isMappedSupperClass;
    }

    @Override
    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    @Override
    @NotNull
    public Annotation getImmutableAnnotation() {
        return this.immutableAnnotation;
    }

    @Nullable
    KClass<?> getKotlinClass() {
        return this.kotlinClass;
    }

    @Override
    public boolean isAssignableFrom(ImmutableType type) {
        return this.javaClass.isAssignableFrom(type.getJavaClass());
    }

    @Override
    @Nullable
    public ImmutableType getSuperType() {
        return this.superType;
    }

    @Override
    @NotNull
    public BiFunction<DraftContext, Object, Draft> getDraftFactory() {
        return this.draftFactory;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    @Override
    public ImmutableProp getIdProp() {
        return this.idProp;
    }

    @Override
    @Nullable
    public ImmutableProp getVersionProp() {
        return this.versionProp;
    }

    @Override
    @Nullable
    public LogicalDeletedInfo getDeclaredLogicalDeletedInfo() {
        return this.declaredLogicalDeletedInfo;
    }

    @Override
    @NotNull
    public Set<ImmutableProp> getKeyProps() {
        return this.keyProps;
    }

    @Override
    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getProps() {
        Map<String, ImmutableProp> props = this.props;
        if (props == null) {
            if (this.superType == null) {
                props = this.declaredProps;
            } else {
                props = new LinkedHashMap<String, ImmutableProp>(this.superType.getProps());
                for (ImmutableProp declaredProp : this.declaredProps.values()) {
                    ImmutableProp conflictProp = props.put(declaredProp.getName(), declaredProp);
                    if (conflictProp == null || conflictProp == ((ImmutablePropImpl)declaredProp).getBase()) continue;
                    throw new ModelException("The property \"" + declaredProp + "\" overrides property of super type, this is not allowed");
                }
            }
            this.props = Collections.unmodifiableMap(props);
        }
        return props;
    }

    @Override
    @NotNull
    public ImmutableProp getProp(String name) {
        ImmutableProp prop = this.getProps().get(name);
        if (prop == null) {
            throw new IllegalArgumentException("There is no property \"" + name + "\" in \"" + this + "\"");
        }
        return prop;
    }

    @Override
    @NotNull
    public ImmutableProp getProp(int id) {
        ImmutableProp[] arr = this.getPropArr();
        if (id < 1 || id >= arr.length) {
            throw new IllegalArgumentException("There is no property whose id is " + id + " in \"" + this + "\"");
        }
        return arr[id];
    }

    @NotNull
    private ImmutableProp[] getPropArr() {
        ImmutableProp[] arr = this.propArr;
        if (arr == null) {
            arr = new ImmutableProp[this.getProps().size() + 1];
            Iterator<ImmutableProp> iterator = this.getProps().values().iterator();
            while (iterator.hasNext()) {
                ImmutableProp prop;
                arr[prop.getId()] = prop = iterator.next();
            }
            this.propArr = arr;
        }
        return arr;
    }

    @Override
    @NotNull
    public List<ImmutableProp> getPropChainByColumnName(String columnName) {
        String cmpName = DatabaseIdentifiers.comparableIdentifier(columnName);
        List<ImmutableProp> chain = this.getChainMap().get(cmpName);
        if (chain == null) {
            throw new IllegalArgumentException("There is no property chain whose column name is \"" + columnName + "\" in type \"" + this + "\"");
        }
        return chain;
    }

    private Map<String, List<ImmutableProp>> getChainMap() {
        Map<String, List<ImmutableProp>> map = this.chainMap;
        if (map == null) {
            this.validateEntity();
            map = new LinkedHashMap<String, List<ImmutableProp>>();
            for (ImmutableProp prop : this.getProps().values()) {
                PropChains.addInto(prop, map);
            }
            this.chainMap = map;
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getSelectableProps() {
        Map<String, ImmutableProp> selectableProps = this.selectableProps;
        if (selectableProps == null) {
            selectableProps = new LinkedHashMap<String, ImmutableProp>();
            for (ImmutableProp prop : this.getProps().values()) {
                if (!prop.isId() || !(prop.getStorage() instanceof ColumnDefinition)) continue;
                selectableProps.put(prop.getName(), prop);
            }
            for (ImmutableProp prop : this.getProps().values()) {
                if (prop.isId() || !(prop.getStorage() instanceof ColumnDefinition)) continue;
                selectableProps.put(prop.getName(), prop);
            }
            this.selectableProps = Collections.unmodifiableMap(selectableProps);
        }
        return selectableProps;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getSelectableReferenceProps() {
        Map<String, ImmutableProp> selectableReferenceProps = this.selectableReferenceProps;
        if (selectableReferenceProps == null) {
            this.validateEntity();
            selectableReferenceProps = new LinkedHashMap<String, ImmutableProp>();
            for (ImmutableProp prop : this.getProps().values()) {
                if (!prop.isReference(TargetLevel.PERSISTENT) || !(prop.getStorage() instanceof ColumnDefinition)) continue;
                selectableReferenceProps.put(prop.getName(), prop);
            }
            this.selectableReferenceProps = Collections.unmodifiableMap(selectableReferenceProps);
        }
        return selectableReferenceProps;
    }

    void setDeclaredProps(Map<String, ImmutableProp> map) {
        this.declaredProps = Collections.unmodifiableMap(map);
    }

    void setIdProp(ImmutableProp idProp) {
        Class<?> returnType;
        if (idProp.getDeclaringType() != this) {
            idProp = this.getProp(idProp.getName());
        }
        if (idProp.isEmbedded(EmbeddedLevel.SCALAR)) {
            this.validateEmbeddedIdType(idProp.getTargetType(), null);
        }
        this.idProp = idProp;
        GeneratedValue generatedValue = idProp.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            return;
        }
        Class<? extends IdGenerator> generatorType = generatedValue.generatorType();
        GenerationType strategy = generatedValue.strategy();
        GenerationType strategyFromGeneratorType = GenerationType.AUTO;
        GenerationType strategyFromSequenceName = GenerationType.AUTO;
        if (UserIdGenerator.class.isAssignableFrom(generatorType)) {
            strategyFromGeneratorType = GenerationType.USER;
        } else if (IdentityIdGenerator.class.isAssignableFrom(generatorType)) {
            strategyFromGeneratorType = GenerationType.IDENTITY;
        } else if (SequenceIdGenerator.class.isAssignableFrom(generatorType)) {
            strategyFromGeneratorType = GenerationType.SEQUENCE;
        }
        if (!generatedValue.sequenceName().isEmpty()) {
            strategyFromSequenceName = GenerationType.SEQUENCE;
        }
        if (strategy != GenerationType.AUTO && strategyFromGeneratorType != GenerationType.AUTO && strategy != strategyFromGeneratorType) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation has conflict attributes 'strategy' and 'generatorType'");
        }
        if (strategy != GenerationType.AUTO && strategyFromSequenceName != GenerationType.AUTO && strategy != strategyFromSequenceName) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation has conflict attributes 'strategy' and 'sequenceName'");
        }
        if (strategyFromGeneratorType != GenerationType.AUTO && strategyFromSequenceName != GenerationType.AUTO && strategyFromGeneratorType != strategyFromSequenceName) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation has conflict attributes 'generatorType' and 'sequenceName'");
        }
        if (strategy == GenerationType.AUTO) {
            strategy = strategyFromGeneratorType;
        }
        if (strategy == GenerationType.AUTO) {
            strategy = strategyFromSequenceName;
        }
        if (strategy == GenerationType.AUTO) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation does not have any attributes");
        }
        if (strategy == GenerationType.IDENTITY || strategy == GenerationType.SEQUENCE) {
            returnType = idProp.getElementClass();
            if (!returnType.isPrimitive() && !Number.class.isAssignableFrom(returnType)) {
                throw new ModelException("Illegal property \"" + idProp + "\", it's id generation strategy is \"" + (Object)((Object)strategy) + "\", but that the type of id is not numeric");
            }
        } else if (strategy == GenerationType.USER) {
            Type type;
            returnType = idProp.getElementClass();
            Map typeArguments = TypeUtils.getTypeArguments(generatorType, UserIdGenerator.class);
            Class parsedType = null;
            if (!typeArguments.isEmpty() && (type = (Type)typeArguments.values().iterator().next()) instanceof Class) {
                parsedType = (Class)type;
            }
            if (parsedType == null) {
                throw new ModelException("Illegal property \"" + idProp + "\", the generator type is \"" + generatorType.getName() + "\" does support type argument for \"" + UserIdGenerator.class + "\"");
            }
            if (parsedType != returnType) {
                throw new ModelException("Illegal property \"" + idProp + "\", the generator type is \"" + generatorType.getName() + "\" generates id whose type is \"" + parsedType.getName() + "\" but the property returns \"" + returnType.getName() + "\"");
            }
        }
        if (strategy == GenerationType.USER) {
            IdGenerator idGenerator = null;
            String error = null;
            Throwable errorCause = null;
            if (generatorType == IdGenerator.None.class) {
                error = "'generatorType' must be specified when 'strategy' is 'GenerationType.USER'";
            }
            try {
                idGenerator = generatorType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException ex) {
                error = "cannot create the instance of \"" + generatorType.getName() + "\"";
                errorCause = ex;
            }
            catch (InvocationTargetException ex) {
                error = "cannot create the instance of \"" + generatorType.getName() + "\"";
                errorCause = ex.getTargetException();
            }
            if (error != null) {
                throw new ModelException("Illegal property \"" + idProp + "\" with the annotation @GeneratedValue, " + error, errorCause);
            }
            this.idGenerator = idGenerator;
        } else if (strategy == GenerationType.IDENTITY) {
            this.idGenerator = IdentityIdGenerator.INSTANCE;
        } else if (strategy == GenerationType.SEQUENCE) {
            String sequenceName = generatedValue.sequenceName();
            if (sequenceName.isEmpty()) {
                sequenceName = this.tableName + "_ID_SEQ";
            }
            this.idGenerator = new SequenceIdGenerator(sequenceName);
        }
    }

    void setVersionProp(ImmutableProp versionProp) {
        if (versionProp != null && versionProp.getDeclaringType() != this) {
            versionProp = this.getProp(versionProp.getName());
        }
        this.versionProp = versionProp;
    }

    void setDeclaredLogicalDeletedInfo(LogicalDeletedInfo declaredLogicalDeletedInfo) {
        this.declaredLogicalDeletedInfo = declaredLogicalDeletedInfo;
    }

    void setKeyProps(Set<ImmutableProp> keyProps) {
        LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
        for (ImmutableProp keyProp : keyProps) {
            if (keyProp.getDeclaringType() != this) {
                keyProp = this.getProp(keyProp.getName());
            }
            set.add(keyProp);
        }
        this.keyProps = Collections.unmodifiableSet(set);
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String toString() {
        return this.javaClass.getName();
    }

    private void validateEntity() {
        if (!this.isEntity) {
            throw new IllegalStateException("The current type \"" + this + "\" is not entity");
        }
    }

    private void validateEmbeddedIdType(ImmutableType type, String path) {
        String prefix = path != null ? path + '.' : "";
        for (ImmutableProp prop : type.getProps().values()) {
            if (prop.isNullable()) {
                throw new ModelException("Illegal id property \"" + this + "\", the embedded property \"" + prefix + prop.getName() + "\" cannot be nullable");
            }
            if (!prop.isEmbedded(EmbeddedLevel.SCALAR)) continue;
            this.validateEmbeddedIdType(prop.getTargetType(), prefix + prop.getName());
        }
    }

    private static class PropBuilder {
        final int id;
        final String name;
        final ImmutablePropCategory category;
        final Class<?> elementType;
        final boolean nullable;
        final Class<? extends Annotation> associationType;

        private PropBuilder(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable, Class<? extends Annotation> associationType) {
            this.id = id;
            this.name = name;
            this.category = category;
            this.elementType = elementType;
            this.nullable = nullable;
            this.associationType = associationType;
        }

        public ImmutableProp build(ImmutableTypeImpl declaringType) {
            return new ImmutablePropImpl(declaringType, this.id, this.name, this.category, this.elementType, this.nullable, this.associationType);
        }
    }

    public static class BuilderImpl
    implements ImmutableType.Builder {
        private final KClass<?> kotlinType;
        private final Class<?> javaClass;
        private final ImmutableType superType;
        private final BiFunction<DraftContext, Object, Draft> draftFactory;
        private String idPropName;
        private String versionPropName;
        private String logicalDeletedPropName;
        private final List<String> keyPropNames = new ArrayList<String>();
        private final Set<Integer> propIds;
        private final Map<String, PropBuilder> propBuilderMap = new LinkedHashMap<String, PropBuilder>();

        BuilderImpl(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
            this.kotlinType = null;
            this.javaClass = javaClass;
            this.superType = superType;
            this.draftFactory = draftFactory;
            this.propIds = superType != null ? superType.getProps().values().stream().map(ImmutableProp::getId).collect(Collectors.toSet()) : new HashSet<Integer>();
        }

        BuilderImpl(KClass<?> kotlinType, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
            this.kotlinType = kotlinType;
            this.javaClass = ((ClassBasedDeclarationContainer)kotlinType).getJClass();
            this.superType = superType;
            this.draftFactory = draftFactory;
            this.propIds = superType != null ? superType.getProps().values().stream().map(ImmutableProp::getId).collect(Collectors.toSet()) : new HashSet<Integer>();
        }

        @Override
        public ImmutableType.Builder id(int id, String name, Class<?> elementType) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set id property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            if (this.superType != null && this.superType.getIdProp() != null) {
                throw new IllegalStateException("Cannot set id property for type \"" + this.javaClass.getName() + "\" because there is an id property in the super type \"" + this.superType.getJavaClass().getName() + "\"");
            }
            if (this.idPropName != null) {
                throw new IllegalStateException("Conflict id properties \"" + this.idPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.idPropName = name;
            return this.add(id, name, BuilderImpl.category(elementType), elementType, false);
        }

        @Override
        public ImmutableType.Builder key(int id, String name, Class<?> elementType) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set key property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            this.keyPropNames.add(name);
            return this.add(id, name, BuilderImpl.category(elementType), elementType, false);
        }

        @Override
        public ImmutableType.Builder keyReference(int id, String name, Class<?> elementType, boolean nullable) {
            this.keyPropNames.add(name);
            return this.add(id, name, ImmutablePropCategory.REFERENCE, elementType, nullable, ManyToOne.class);
        }

        @Override
        public ImmutableType.Builder version(int id, String name) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set version property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            if (this.superType != null && this.superType.getVersionProp() != null) {
                throw new IllegalStateException("Cannot set version property for type \"" + this.javaClass.getName() + "\" because there is an id property in the super type \"" + this.superType.getJavaClass().getName() + "\"");
            }
            if (this.versionPropName != null) {
                throw new IllegalStateException("Conflict version properties \"" + this.versionPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.versionPropName = name;
            return this.add(id, name, ImmutablePropCategory.SCALAR, Integer.TYPE, false);
        }

        @Override
        public ImmutableType.Builder logicalDeleted(int id, String name, Class<?> elementType, boolean nullable) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set logical deleted property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            if (this.superType != null && this.superType.getIdProp() != null) {
                throw new IllegalStateException("Cannot set logical deleted property for type \"" + this.javaClass.getName() + "\" because there is an id property in the super type \"" + this.superType.getJavaClass().getName() + "\"");
            }
            if (this.logicalDeletedPropName != null) {
                throw new IllegalStateException("Conflict logical deleted properties \"" + this.logicalDeletedPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.logicalDeletedPropName = name;
            return this.add(id, name, ImmutablePropCategory.SCALAR, elementType, nullable);
        }

        @Override
        public ImmutableType.Builder add(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable) {
            return this.add(id, name, category, elementType, nullable, null);
        }

        @Override
        public ImmutableType.Builder add(int id, String name, Class<? extends Annotation> associationType, Class<?> elementType, boolean nullable) {
            ImmutablePropCategory category;
            if (associationType == OneToOne.class || associationType == ManyToOne.class) {
                category = ImmutablePropCategory.REFERENCE;
            } else if (associationType == OneToMany.class || associationType == ManyToMany.class) {
                category = ImmutablePropCategory.REFERENCE_LIST;
            } else {
                throw new IllegalArgumentException("Invalid association type");
            }
            return this.add(id, name, category, elementType, nullable, associationType);
        }

        private ImmutableType.Builder add(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable, Class<? extends Annotation> associationType) {
            if (category.isAssociation() && elementType.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set association for type that is not entity or mapped super class");
            }
            if (!this.propIds.add(id)) {
                throw new IllegalArgumentException("The property id \"" + id + "." + name + "\" is already exists in current type or the super type");
            }
            if (this.propBuilderMap.containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.javaClass.getName() + "." + name + "\", it is already exists");
            }
            if (this.superType != null && this.superType.getProps().containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.javaClass.getName() + "." + name + "\" is already exists in super type");
            }
            this.propBuilderMap.put(name, new PropBuilder(id, name, category, elementType, nullable, associationType));
            return this;
        }

        private static ImmutablePropCategory category(Class<?> elementType) {
            return elementType.isAnnotationPresent(Embeddable.class) ? ImmutablePropCategory.REFERENCE : ImmutablePropCategory.SCALAR;
        }

        @Override
        public ImmutableTypeImpl build() {
            ImmutableProp superIdProp;
            ImmutableTypeImpl type = this.kotlinType != null ? new ImmutableTypeImpl(this.kotlinType, this.superType, this.draftFactory) : new ImmutableTypeImpl(this.javaClass, this.superType, this.draftFactory);
            LinkedHashMap<String, ImmutableProp> map = new LinkedHashMap<String, ImmutableProp>();
            if (this.superType != null && !this.superType.isEntity() && this.javaClass.isAnnotationPresent(Entity.class)) {
                for (ImmutableProp prop : this.superType.getProps().values()) {
                    map.put(prop.getName(), new ImmutablePropImpl(type, (ImmutablePropImpl)prop));
                }
            }
            for (Map.Entry<String, PropBuilder> e : this.propBuilderMap.entrySet()) {
                map.put(e.getKey(), e.getValue().build(type));
            }
            type.setDeclaredProps(map);
            if (this.idPropName != null) {
                type.setIdProp((ImmutableProp)type.declaredProps.get(this.idPropName));
            } else if (type.superType != null && (superIdProp = type.superType.getIdProp()) != null) {
                type.setIdProp(superIdProp);
            }
            if (this.versionPropName != null) {
                type.setVersionProp((ImmutableProp)type.declaredProps.get(this.versionPropName));
            } else if (type.superType != null) {
                type.setVersionProp(type.superType.getVersionProp());
            }
            if (this.logicalDeletedPropName != null) {
                type.setDeclaredLogicalDeletedInfo(LogicalDeletedInfo.of((ImmutableProp)type.declaredProps.get(this.logicalDeletedPropName)));
            }
            LinkedHashSet<ImmutableProp> keyProps = type.superType != null ? new LinkedHashSet<ImmutableProp>(type.superType.getKeyProps()) : new LinkedHashSet();
            for (String keyPropName : this.keyPropNames) {
                keyProps.add((ImmutableProp)type.declaredProps.get(keyPropName));
            }
            type.setKeyProps(keyProps);
            return type;
        }
    }
}

