/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson.meta;

import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Objects;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.jackson.meta.BeanProp;
import org.babyfish.jimmer.meta.ImmutableProp;

public class BeanProps {
    private static final StaticCache<Key, BeanProp> CACHE = new StaticCache<Key, BeanProp>(BeanProps::create);

    private BeanProps() {
    }

    public static BeanProp get(TypeFactory typeFactory, ImmutableProp prop) {
        return CACHE.get(new Key(typeFactory, prop));
    }

    private static BeanProp create(Key key) {
        return new BeanProp((TypeResolutionContext)new TypeResolutionContext.Empty(key.typeFactory), key.prop);
    }

    private static class Key {
        final TypeFactory typeFactory;
        final ImmutableProp prop;

        private Key(TypeFactory typeFactory, ImmutableProp prop) {
            this.typeFactory = typeFactory;
            this.prop = prop;
        }

        public int hashCode() {
            return Objects.hash(this.typeFactory, this.prop);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.typeFactory.equals(key.typeFactory) && this.prop == key.prop;
        }

        public String toString() {
            return "Key{typeFactory=" + this.typeFactory + ", prop=" + this.prop + '}';
        }
    }
}

