/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PropName {
    private final String value;
    private final boolean recordStyle;

    private PropName(String value, boolean recordStyle) {
        this.value = value;
        this.recordStyle = recordStyle;
    }

    public String getText() {
        return this.value;
    }

    public boolean isRecordStyle() {
        return this.recordStyle;
    }

    public static PropName fromBeanGetter(Method getter) {
        Class<?> returnType = getter.getReturnType();
        if (returnType == Void.TYPE || Modifier.isStatic(getter.getModifiers()) || getter.getParameters().length != 0) {
            return null;
        }
        return PropName.fromBeanGetterName(getter.getName(), returnType == Boolean.TYPE);
    }

    public static PropName fromBeanGetterName(String getterName, boolean isBoolean) {
        if (isBoolean && getterName.startsWith("is") && getterName.length() > 2) {
            return new PropName(PropName.lowercaseHead(getterName.substring(2)), false);
        }
        if (getterName.startsWith("get") && getterName.length() > 3) {
            return new PropName(PropName.lowercaseHead(getterName.substring(3)), false);
        }
        return new PropName(getterName, true);
    }

    private static String lowercaseHead(String name) {
        char c;
        char[] arr = name.toCharArray();
        for (int i = 0; i < arr.length && Character.isUpperCase(c = arr[i]); ++i) {
            arr[i] = Character.toLowerCase(c);
        }
        return new String(arr);
    }
}

