/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl.dto.ast;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.babyfish.jimmer.meta.impl.dto.ast.DtoAstException;
import org.babyfish.jimmer.meta.impl.dto.ast.DtoLexer;
import org.babyfish.jimmer.meta.impl.dto.ast.DtoParser;
import org.babyfish.jimmer.meta.impl.dto.ast.DtoProp;
import org.babyfish.jimmer.meta.impl.dto.ast.DtoPropImpl;
import org.babyfish.jimmer.meta.impl.dto.ast.DtoType;
import org.babyfish.jimmer.meta.impl.dto.ast.spi.BaseProp;
import org.babyfish.jimmer.meta.impl.dto.ast.spi.BaseType;
import org.jetbrains.annotations.Nullable;

public abstract class DtoCompiler<T extends BaseType, P extends BaseProp> {
    private final T baseType;

    protected DtoCompiler(T baseType) {
        this.baseType = baseType;
    }

    public List<DtoType<T, P>> compile(String code) {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(code));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    public List<DtoType<T, P>> compile(Reader reader) throws IOException {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(reader));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    public List<DtoType<T, P>> compile(InputStream input) throws IOException {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(input));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    private List<DtoType<T, P>> parse(DtoParser parser) {
        List<DtoParser.DtoTypeContext> dtoTypes = parser.dto().dtoTypes;
        int size = dtoTypes.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int ii = i + 1; ii < size; ++ii) {
                if (!dtoTypes.get((int)i).name.getText().equals(dtoTypes.get(ii).getText())) continue;
                throw new DtoAstException(dtoTypes.get((int)ii).name.getLine(), "Duplicate dto type name \"" + dtoTypes.get(ii).getText() + "\"");
            }
        }
        return dtoTypes.stream().map(it -> new DtoTypeBuilder(this, this.baseType, false).parse((DtoParser.DtoTypeContext)((Object)it))).collect(Collectors.toList());
    }

    protected abstract boolean isEntity(T var1);

    protected abstract T getSuperType(T var1);

    protected abstract Map<String, P> getDeclaredProps(T var1);

    protected abstract Map<String, P> getProps(T var1);

    protected abstract boolean isId(P var1);

    protected abstract boolean isKey(P var1);

    protected abstract T getTargetType(P var1);

    private static class DtoErrorListener
    extends BaseErrorListener {
        private DtoErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            throw new DtoAstException(line, msg);
        }
    }

    private static class DtoTypeBuilder {
        private final T baseType;
        private final boolean hasKey;
        private boolean isInput;
        private final Map<String, DtoProp<T, P>> propMap = new LinkedHashMap();
        private final Set<String> finalPropNames = new HashSet<String>();
        private final P recursiveBaseProp;
        private final String recursiveAlias;
        final /* synthetic */ DtoCompiler this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        DtoTypeBuilder(T baseType, boolean isInput) {
            this((DtoCompiler)n, (BaseType)baseType, isInput, null, null);
        }

        DtoTypeBuilder(T baseType, boolean isInput, P recursiveBaseProp, String recursiveAlias) {
            this.this$0 = var1_1;
            this.baseType = baseType;
            this.hasKey = var1_1.getProps(baseType).values().stream().anyMatch(var1_1::isKey);
            this.isInput = isInput;
            this.recursiveBaseProp = recursiveBaseProp;
            this.recursiveAlias = recursiveAlias;
        }

        DtoType<T, P> parse(DtoParser.DtoTypeContext ctx) {
            if (ctx.modifier != null) {
                if (!ctx.modifier.getText().equals("input")) {
                    throw new DtoAstException(ctx.modifier.getLine(), "If the modifier is specified, it must be \"input\"");
                }
                this.isInput = true;
            }
            return new DtoType(this.parse(ctx.body), ctx.name.getText());
        }

        private DtoType<T, P> parse(DtoParser.DtoBodyContext ctx) {
            RecursiveDtoProp recursiveDtoProp;
            DtoParser.MacroContext macro = ctx.macro();
            if (macro != null) {
                this.parse(macro);
            }
            for (DtoParser.ExplicitPropContext explicitPropCtx : ctx.explicitProps) {
                this.parse(explicitPropCtx);
            }
            RecursiveDtoProp recursiveDtoProp2 = recursiveDtoProp = this.recursiveBaseProp != null ? new RecursiveDtoProp((BaseProp)this.recursiveBaseProp, this.recursiveAlias, null) : null;
            if (recursiveDtoProp != null) {
                this.propMap.put(this.recursiveBaseProp.getName(), recursiveDtoProp);
            }
            DtoType dtoType = new DtoType(this.baseType, this.isInput, new ArrayList(this.propMap.values()));
            if (recursiveDtoProp != null) {
                recursiveDtoProp.targetType = dtoType;
            }
            return dtoType;
        }

        private void parse(DtoParser.MacroContext macro) {
            if (!macro.name.getText().equals("allScalars")) {
                throw new DtoAstException(macro.name.getLine(), "If the macro is specified, it must be \"allScalars\"");
            }
            List<DtoParser.QualifiedNameContext> args = macro.args;
            LinkedHashSet<BaseType> explicitBaseTypes = null;
            if (!args.isEmpty()) {
                explicitBaseTypes = new LinkedHashSet<BaseType>();
                LinkedHashMap<String, List> nameBaseTypeMap = new LinkedHashMap<String, List>();
                LinkedHashMap qualifiedNameBaseTypeMap = new LinkedHashMap();
                Object bt = this.baseType;
                while (bt != null) {
                    nameBaseTypeMap.computeIfAbsent(bt.getName(), it -> new ArrayList()).add(bt);
                    qualifiedNameBaseTypeMap.put(bt.getQualifiedName(), bt);
                    bt = this.this$0.getSuperType(bt);
                }
                for (DtoParser.QualifiedNameContext qnCtx : args) {
                    BaseType baseType;
                    String typeName = qnCtx.parts.stream().map(Token::getText).collect(Collectors.joining("."));
                    List baseTypes = (List)nameBaseTypeMap.get(typeName);
                    if (baseTypes != null) {
                        if (baseTypes.size() > 1) {
                            throw new DtoAstException(qnCtx.start.getLine(), "The type name \"" + typeName + "\" indicates conflict types: " + baseTypes.size());
                        }
                        baseType = (BaseType)baseTypes.get(0);
                    } else {
                        baseType = (BaseType)qualifiedNameBaseTypeMap.get(typeName);
                    }
                    if (baseType == null) {
                        throw new DtoAstException(qnCtx.start.getLine(), "The type name \"" + typeName + "\" indicates nothing");
                    }
                    explicitBaseTypes.add(baseType);
                }
            }
            if (explicitBaseTypes == null) {
                for (BaseProp baseProp : this.this$0.getProps(this.baseType).values()) {
                    if (baseProp.isTransient() || this.this$0.getTargetType(baseProp) != null) continue;
                    this.propMap.put(baseProp.getName(), new DtoPropImpl(baseProp, null, null, this.isInput && this.this$0.isId(baseProp) && this.hasKey, false, false));
                    this.finalPropNames.add(baseProp.getName());
                }
            } else {
                for (BaseType baseType : explicitBaseTypes) {
                    for (BaseProp baseProp : this.this$0.getDeclaredProps(baseType).values()) {
                        if (baseProp.isTransient() || this.this$0.getTargetType(baseProp) != null) continue;
                        this.propMap.put(baseProp.getName(), new DtoPropImpl(baseProp, null, null, this.isInput && this.this$0.isId(baseProp) && this.hasKey, false, false));
                        this.finalPropNames.add(baseProp.getName());
                    }
                }
            }
        }

        private void parse(DtoParser.ExplicitPropContext ctx) {
            if (ctx.positiveProp() != null) {
                this.parse(ctx.positiveProp());
            } else {
                this.parse(ctx.negativeProp());
            }
        }

        private void parse(DtoParser.PositivePropContext ctx) {
            Token reportErrorToken;
            String finalName;
            boolean recursive;
            BaseProp baseProp;
            if (this.recursiveBaseProp != null && ctx.prop.getText().equals(this.recursiveBaseProp.getName())) {
                throw new DtoAstException(ctx.prop.getLine(), "Cannot specify the property \"" + this.recursiveBaseProp + "\" here, because it is recursive property of current context");
            }
            boolean idOnly = false;
            if (ctx.func != null) {
                if (!ctx.func.getText().equals("id")) {
                    throw new DtoAstException(ctx.func.getLine(), "The function name must be \"id\"");
                }
                if (!this.this$0.isEntity(this.baseType)) {
                    throw new DtoAstException(ctx.func.getLine(), "Cannot call function \"id\" because the current base type \"" + this.baseType.getQualifiedName() + "\" is not entity");
                }
                idOnly = true;
            }
            if ((baseProp = (BaseProp)this.this$0.getProps(this.baseType).get(ctx.prop.getText())) == null) {
                throw new DtoAstException(ctx.prop.getLine(), "No property \"" + ctx.prop.getText() + "\" is declared in \"" + this.baseType.getQualifiedName() + "\"");
            }
            if (baseProp.isTransient() && !baseProp.hasTransientResolver()) {
                throw new DtoAstException(ctx.prop.getLine(), "The property \"" + baseProp.getName() + "\" cannot be declared in dto because it is transient but has no transient resolver");
            }
            if (idOnly && this.this$0.getTargetType(baseProp) == null) {
                throw new DtoAstException(ctx.func.getLine(), "Cannot call the function \"id\" because the property \"" + baseProp.getName() + "\" is not association");
            }
            String alias = null;
            if (ctx.alias != null) {
                alias = ctx.alias.getText();
            } else if (idOnly) {
                alias = baseProp.getName() + "Id";
            }
            if (this.recursiveAlias != null && this.recursiveAlias.equals(alias)) {
                throw new DtoAstException(ctx.alias.getLine(), "Cannot assign the alias \"" + alias + "\" to the the property \"" + this.recursiveBaseProp + "\" here, because it is the alias of recursive property of current context");
            }
            if (idOnly && baseProp.isList() && alias == null) {
                throw new DtoAstException(ctx.func.getLine(), "The property \"" + baseProp.getName() + "\" is wrapped by `id(...)`, the alias is required because it is list");
            }
            boolean bl = recursive = ctx.recursive != null;
            if (recursive) {
                Object targetType = this.this$0.getTargetType(baseProp);
                if (targetType == null) {
                    throw new DtoAstException(ctx.recursive.getLine(), "The property \"" + baseProp.getName() + "\" cannot be recursive because it is not association");
                }
                if (targetType != this.baseType) {
                    throw new DtoAstException(ctx.recursive.getLine(), "The property \"" + baseProp.getName() + "\" cannot be recursive because does not returns the declaring type \"" + this.baseType.getQualifiedName() + "\"");
                }
            }
            DtoType targetDtoType = null;
            if (ctx.dtoBody() != null) {
                if (idOnly) {
                    throw new DtoAstException(ctx.dtoBody().start.getLine(), "Cannot specify the target dto type for id(" + baseProp.getName() + ") because it is wrapped by id(...)");
                }
                if (this.this$0.getTargetType(baseProp) == null) {
                    throw new DtoAstException(ctx.dtoBody().start.getLine(), "Cannot specify the target dto type for \"" + baseProp.getName() + "\" because it is not association");
                }
                targetDtoType = new DtoTypeBuilder(this.this$0, this.this$0.getTargetType(baseProp), this.isInput, recursive ? baseProp : null, alias).parse(ctx.dtoBody());
            } else if (this.this$0.getTargetType(baseProp) != null && !idOnly) {
                throw new DtoAstException(ctx.dtoBody().start.getLine(), "The target dto type for association \"" + baseProp.getName() + "\" is required");
            }
            this.propMap.put(baseProp.getName(), new DtoPropImpl(baseProp, alias, targetDtoType, recursive, idOnly, recursive));
            String string = finalName = alias != null ? alias : baseProp.getName();
            Token token = ctx.alias != null ? ctx.alias : (reportErrorToken = ctx.func != null ? ctx.func : ctx.prop);
            if (!this.finalPropNames.add(finalName)) {
                throw new DtoAstException(reportErrorToken.getLine(), "The duplicate property alias \"" + finalName + "\"");
            }
        }

        private void parse(DtoParser.NegativePropContext ctx) {
            BaseProp baseProp = (BaseProp)this.this$0.getProps(this.baseType).get(ctx.Identifier().getText());
            if (baseProp == null) {
                throw new DtoAstException(ctx.stop.getLine(), "No property \"" + ctx.Identifier().getText() + "\" is declared in \"" + this.baseType.getQualifiedName() + "\"");
            }
            DtoProp prop = this.propMap.remove(baseProp.getName());
            if (prop != null) {
                this.finalPropNames.remove(prop.getName());
            }
        }
    }

    private static class RecursiveDtoProp<T extends BaseType, P extends BaseProp>
    implements DtoProp<T, P> {
        private final P baseProp;
        private final String alias;
        DtoType<T, P> targetType;

        private RecursiveDtoProp(P baseProp, String alias) {
            this.baseProp = baseProp;
            this.alias = alias;
        }

        @Override
        public P getBaseProp() {
            return this.baseProp;
        }

        @Override
        public String getName() {
            return this.alias != null ? this.alias : this.baseProp.getName();
        }

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        public boolean isIdOnly() {
            return false;
        }

        @Override
        @Nullable
        public String getAlias() {
            return this.alias;
        }

        @Override
        @Nullable
        public DtoType<T, P> getTargetType() {
            return this.targetType;
        }

        @Override
        public boolean isRecursive() {
            return true;
        }

        @Override
        public boolean isNewTarget() {
            return false;
        }

        /* synthetic */ RecursiveDtoProp(BaseProp x0, String x1, 1 x2) {
            this(x0, x1);
        }
    }
}

