/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.converter;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.ImmutableConverter;
import org.babyfish.jimmer.impl.converter.ImmutableConverterImpl;
import org.babyfish.jimmer.impl.util.PropName;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;

public class ImmutableConverterBuilderImpl<Dynamic, Static>
implements ImmutableConverter.Builder<Dynamic, Static> {
    private final ImmutableType immutableType;
    private final Class<Static> staticType;
    private final Map<String, StaticProp> staticPropMap;
    private BiConsumer<Draft, Static> draftModifier;
    private Map<ImmutableProp, ImmutableConverterImpl.Field> mappingMap = new HashMap<ImmutableProp, ImmutableConverterImpl.Field>();

    public ImmutableConverterBuilderImpl(Class<Dynamic> immutableType, Class<Static> staticType, boolean byField) {
        this.immutableType = ImmutableType.get(immutableType);
        this.staticType = staticType;
        this.staticPropMap = ImmutableConverterBuilderImpl.staticProps(staticType, byField);
        if (this.staticPropMap.isEmpty()) {
            throw new IllegalArgumentException("Cannot map the static type \"" + staticType.getName() + "\" by " + (byField ? "FIELDS" : "METHODS") + ", not static properties has been found");
        }
    }

    @Override
    public ImmutableConverter.Builder<Dynamic, Static> map(ImmutableProp prop, String staticPropName, Consumer<ImmutableConverter.Mapping<Static, ?>> block) {
        this.validateProp(prop);
        this.mapImpl(prop, staticPropName, block, false, false);
        return this;
    }

    @Override
    public ImmutableConverter.Builder<Dynamic, Static> mapList(ImmutableProp prop, String staticPropName, Consumer<ImmutableConverter.ListMapping<Static, ?>> block) {
        this.validateProp(prop);
        if (!prop.isReferenceList(TargetLevel.OBJECT) && !prop.isScalarList()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not list property");
        }
        this.mapImpl(prop, staticPropName, block, true, false);
        return this;
    }

    @Override
    public ImmutableConverter.Builder<Dynamic, Static> unmapStaticProps(Collection<String> staticPropNames) {
        for (String staticPropName : staticPropNames) {
            this.staticProp((String)staticPropName, (boolean)false).mapped = true;
        }
        return this;
    }

    @Override
    public ImmutableConverter.Builder<Dynamic, Static> setDraftModifier(BiConsumer<Draft, Static> draftModifier) {
        this.draftModifier = draftModifier;
        return this;
    }

    @Override
    public ImmutableConverter<Dynamic, Static> build() {
        for (ImmutableProp prop : this.immutableType.getProps().values()) {
            if (prop.isAssociation(TargetLevel.ENTITY) || this.mappingMap.containsKey(prop)) continue;
            this.mapImpl(prop, prop.getName(), null, prop.isScalarList() || prop.isReferenceList(TargetLevel.OBJECT), true);
        }
        List unmappedStaticProps = this.staticPropMap.values().stream().filter(it -> !it.mapped).collect(Collectors.toList());
        if (!unmappedStaticProps.isEmpty()) {
            throw new IllegalArgumentException(unmappedStaticProps + " has not not been mapped");
        }
        return new ImmutableConverterImpl(this.immutableType, this.staticType, this.mappingMap.values().stream().filter(Objects::nonNull).collect(Collectors.toList()), this.draftModifier);
    }

    private void validateProp(ImmutableProp prop) {
        ImmutableType declaringType = prop.getDeclaringType();
        for (ImmutableType type = this.immutableType; type != null; type = type.getSuperType()) {
            if (declaringType != type) continue;
            return;
        }
        throw new IllegalArgumentException("\"" + prop + "\" is not property of \"" + this.immutableType + "\"");
    }

    private void mapImpl(ImmutableProp prop, String staticPropName, Consumer<?> mappingBuilderConsumer, boolean treatAsList, boolean autoMapping) {
        FieldBuilder builder;
        StaticProp staticProp = this.staticProp(staticPropName, autoMapping);
        if (staticProp == null) {
            return;
        }
        staticProp.mapped = true;
        FieldBuilder fieldBuilder = builder = treatAsList ? new ListMappingImpl(prop, staticProp.method, staticProp.field, autoMapping) : new MappingImpl(prop, staticProp.method, staticProp.field, autoMapping);
        if (mappingBuilderConsumer != null) {
            mappingBuilderConsumer.accept(builder);
        }
        this.mappingMap.put(prop, builder.build());
    }

    private StaticProp staticProp(String staticPropName, boolean nullable) {
        StaticProp staticProp = this.staticPropMap.get(staticPropName);
        if (nullable || staticProp != null) {
            return staticProp;
        }
        throw new IllegalArgumentException("Illegal static property name \"" + staticPropName + "\", available choices are " + this.staticPropMap.keySet());
    }

    private static Map<String, StaticProp> staticProps(Class<?> staticType, boolean byField) {
        HashMap<String, StaticProp> possiblePropMap = new HashMap<String, StaticProp>();
        ImmutableConverterBuilderImpl.possibleStaticProps(staticType, byField, possiblePropMap);
        TreeMap<String, StaticProp> map = new TreeMap<String, StaticProp>();
        for (Map.Entry e : possiblePropMap.entrySet()) {
            if (!((StaticProp)e.getValue()).use()) continue;
            map.put((String)e.getKey(), (StaticProp)e.getValue());
        }
        return map;
    }

    private static void possibleStaticProps(Class<?> staticType, boolean byField, Map<String, StaticProp> map) {
        if (staticType == null || staticType == Object.class) {
            return;
        }
        if (!byField) {
            for (AccessibleObject accessibleObject : staticType.getDeclaredMethods()) {
                PropName propName = PropName.fromBeanGetter((Method)accessibleObject);
                if (propName == null) continue;
                StaticProp staticProp = map.get(propName.getText());
                if (staticProp == null) {
                    staticProp = new StaticProp(propName.getText(), propName.isRecordStyle());
                    staticProp.method = accessibleObject;
                    map.put(propName.getText(), staticProp);
                    continue;
                }
                if (!staticProp.mayBe) continue;
                staticProp.method = accessibleObject;
                staticProp.mayBe = propName.isRecordStyle();
            }
        }
        for (AccessibleObject accessibleObject : staticType.getDeclaredFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            StaticProp staticProp = map.get(((Field)accessibleObject).getName());
            if (staticProp == null) {
                staticProp = new StaticProp(((Field)accessibleObject).getName(), !byField);
                staticProp.field = accessibleObject;
                map.put(((Field)accessibleObject).getName(), staticProp);
                continue;
            }
            if (!staticProp.mayBe) continue;
            staticProp.field = accessibleObject;
            staticProp.mayBe = !byField;
        }
        ImmutableConverterBuilderImpl.possibleStaticProps(staticType.getSuperclass(), byField, map);
        for (AnnotatedElement annotatedElement : staticType.getInterfaces()) {
            ImmutableConverterBuilderImpl.possibleStaticProps(annotatedElement, byField, map);
        }
    }

    private static class StaticProp {
        final String name;
        boolean mayBe;
        Method method;
        Field field;
        boolean mapped;

        StaticProp(String name, boolean mayBe) {
            this.name = name;
            this.mayBe = mayBe;
        }

        boolean use() {
            Class<?> methodType;
            if (!this.mayBe) {
                this.prepare();
                return true;
            }
            if (this.method != null && this.field != null && (methodType = this.method.getReturnType()) == this.field.getType()) {
                this.prepare();
                return true;
            }
            return false;
        }

        private void prepare() {
            if (this.method != null) {
                this.method.setAccessible(true);
            }
            if (this.field != null) {
                this.field.setAccessible(true);
            }
        }

        public String toString() {
            return this.method != null ? this.method.toString() : this.field.toString();
        }
    }

    private static class ListMappingImpl<Static, DynamicProp>
    implements ImmutableConverter.ListMapping<Static, DynamicProp>,
    FieldBuilder {
        private final ImmutableProp prop;
        private final Method method;
        private final Field field;
        private final boolean autoMapping;
        private Predicate<?> cond;
        protected Function<?, ?> elementConverter;
        private Supplier<?> defaultElementSupplier;

        private ListMappingImpl(ImmutableProp prop, Method method, Field field, boolean autoMapping) {
            this.prop = prop;
            this.method = method;
            this.field = field;
            this.autoMapping = autoMapping;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, DynamicProp> useIf(Predicate<Static> cond) {
            this.cond = cond;
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, DynamicProp> elementConverter(Function<?, DynamicProp> elementConverter) {
            this.elementConverter = new ListConverter(elementConverter);
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, DynamicProp> nestedConverter(ImmutableConverter<DynamicProp, ?> nestedElementConverter) {
            this.elementConverter((Function<?, DynamicProp>)((Function<Object, Object>)element -> nestedElementConverter.convert(element)));
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, DynamicProp> defaultElement(DynamicProp defaultElement) {
            this.defaultElementSupplier = () -> defaultElement;
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, DynamicProp> defaultElement(Supplier<DynamicProp> defaultElementSupplier) {
            this.defaultElementSupplier = defaultElementSupplier;
            return this;
        }

        @Override
        public ImmutableConverterImpl.Field build() {
            return ImmutableConverterImpl.Field.create(this.cond, this.prop, this.method, this.field, this.elementConverter, this.defaultElementSupplier, this.autoMapping);
        }

        private class ListConverter<DynamicProp>
        implements Function<List<?>, List<DynamicProp>> {
            private final Function<?, DynamicProp> elementConverter;

            private ListConverter(Function<?, DynamicProp> elementConverter) {
                this.elementConverter = elementConverter;
            }

            @Override
            public List<DynamicProp> apply(List<?> list) {
                ArrayList newList = new ArrayList(list.size());
                for (Object staticElement : list) {
                    Object dynamicElement = staticElement == null ? (ListMappingImpl.this.defaultElementSupplier == null ? null : ListMappingImpl.this.defaultElementSupplier.get()) : (this.elementConverter == null ? staticElement : this.elementConverter.apply(staticElement));
                    newList.add(dynamicElement);
                }
                return newList;
            }
        }
    }

    private static class MappingImpl<Static, DynamicProp>
    implements ImmutableConverter.Mapping<Static, DynamicProp>,
    FieldBuilder {
        private final ImmutableProp prop;
        private final Method method;
        private final Field field;
        private final boolean autoMapping;
        private Predicate<?> cond;
        protected Function<?, ?> valueConverter;
        private Supplier<?> defaultValueSupplier;

        private MappingImpl(ImmutableProp prop, Method method, Field field, boolean autoMapping) {
            this.prop = prop;
            this.method = method;
            this.field = field;
            this.autoMapping = autoMapping;
        }

        @Override
        public ImmutableConverter.Mapping<Static, DynamicProp> useIf(Predicate<Static> cond) {
            this.cond = cond;
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, DynamicProp> valueConverter(Function<?, DynamicProp> valueConverter) {
            this.valueConverter = valueConverter;
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, DynamicProp> nestedConverter(ImmutableConverter<DynamicProp, ?> nestedValueConverter) {
            this.valueConverter(value -> nestedValueConverter.convert(value));
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, DynamicProp> defaultValue(DynamicProp defaultValue) {
            this.defaultValueSupplier = () -> defaultValue;
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, DynamicProp> defaultValue(Supplier<DynamicProp> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
            return this;
        }

        @Override
        public ImmutableConverterImpl.Field build() {
            return ImmutableConverterImpl.Field.create(this.cond, this.prop, this.method, this.field, this.valueConverter, this.defaultValueSupplier, this.autoMapping);
        }
    }

    private static interface FieldBuilder {
        public ImmutableConverterImpl.Field build();
    }
}

