/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.evaluation;

import java.util.List;
import org.babyfish.jimmer.evaluation.Accumulator;
import org.babyfish.jimmer.evaluation.Path;
import org.babyfish.jimmer.evaluation.PathImpl;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;

class Root<T> {
    T result;
    private final Accumulator<T> accumulator;

    public Root(T result, Accumulator<T> accumulator) {
        this.result = result;
        this.accumulator = accumulator;
    }

    public void eval(ImmutableSpi spi) {
        this.evaluate(null, spi);
    }

    private void evaluate(Path ctx, ImmutableSpi spi) {
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            int propId = prop.getId();
            boolean isLoaded = spi.__isLoaded(propId);
            Object value = spi.__isLoaded(propId) ? spi.__get(propId) : null;
            PathImpl propCtx = new PathImpl(ctx != null ? ctx : this, spi, prop, -1, isLoaded, value);
            this.result = this.accumulator.accumulate(this.result, propCtx);
            if (!prop.isAssociation(TargetLevel.OBJECT)) continue;
            if (value instanceof List) {
                int childIndex = 0;
                for (Object child : (List)value) {
                    this.evaluate(new PathImpl(propCtx, spi, prop, childIndex++, isLoaded, child), (ImmutableSpi)child);
                }
                continue;
            }
            if (value == null) continue;
            this.evaluate(new PathImpl(propCtx, spi, prop, -1, isLoaded, value), (ImmutableSpi)value);
        }
    }
}

