/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.meta.Column;

public class ImmutableObjects {
    private static final ObjectMapper MAPPER;

    private ImmutableObjects() {
    }

    public static boolean isLoaded(Object immutable, int prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__isLoaded(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static boolean isLoaded(Object immutable, String prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__isLoaded(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static boolean isLoaded(Object immutable, ImmutableProp prop) {
        return ImmutableObjects.isLoaded(immutable, prop.getId());
    }

    public static boolean isLoaded(Object immutable, TypedProp<?, ?> prop) {
        return ImmutableObjects.isLoaded(immutable, prop.unwrap().getId());
    }

    public static Object get(Object immutable, int prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__get(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static Object get(Object immutable, String prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__get(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static Object get(Object immutable, ImmutableProp prop) {
        return ImmutableObjects.get(immutable, prop.getId());
    }

    public static <T, X> X get(T immutable, TypedProp<T, X> prop) {
        return (X)ImmutableObjects.get(immutable, prop.unwrap().getId());
    }

    public static boolean isIdOnly(Object immutable) {
        if (immutable == null) {
            return false;
        }
        if (immutable instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)immutable;
            ImmutableType type = spi.__type();
            ImmutableProp idProp = type.getIdProp();
            if (idProp == null) {
                throw new IllegalArgumentException("The object type \"" + type + "\" does not have id property");
            }
            for (ImmutableProp prop : type.getProps().values()) {
                if (prop.isId()) {
                    if (spi.__isLoaded(prop.getId())) continue;
                    throw new IllegalArgumentException("The id of " + spi + " is unloaded");
                }
                if (!spi.__isLoaded(prop.getId())) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static <T> T makeIdOnly(ImmutableType type, Object id) {
        ImmutableProp idProp = type.getIdProp();
        if (idProp == null) {
            throw new IllegalArgumentException("No id property in \"" + type + "\"");
        }
        if (id == null) {
            return null;
        }
        return (T)Internal.produce(type, null, draft -> {
            DraftSpi targetDraft = (DraftSpi)draft;
            targetDraft.__set(idProp.getId(), id);
        });
    }

    public static boolean isLonely(Object immutable) {
        if (immutable instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)immutable;
            ImmutableType type = spi.__type();
            for (ImmutableProp prop : type.getProps().values()) {
                if (!prop.isAssociation(TargetLevel.ENTITY) || !spi.__isLoaded(prop.getId())) continue;
                if (prop.getStorage() instanceof Column) {
                    ImmutableSpi target = (ImmutableSpi)spi.__get(prop.getId());
                    if (target == null || ImmutableObjects.isIdOnly(target)) continue;
                    return false;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static <T> T toLonely(T immutable) {
        if (immutable == null) {
            return null;
        }
        ImmutableSpi spi = (ImmutableSpi)immutable;
        ImmutableType type = spi.__type();
        return (T)Internal.produce(type, immutable, draft -> {
            for (ImmutableProp prop : type.getProps().values()) {
                int propId = prop.getId();
                if (!prop.isAssociation(TargetLevel.ENTITY) || !spi.__isLoaded(propId)) continue;
                if (prop.getStorage() instanceof Column) {
                    ImmutableSpi target = (ImmutableSpi)spi.__get(propId);
                    if (target == null) continue;
                    ImmutableType targetType = prop.getTargetType();
                    int targetIdPropId = targetType.getIdProp().getId();
                    if (!target.__isLoaded(targetIdPropId)) {
                        ((DraftSpi)draft).__unload(propId);
                        continue;
                    }
                    if (ImmutableObjects.isIdOnly(target)) continue;
                    Object targetId = target.__get(targetIdPropId);
                    ((DraftSpi)draft).__set(propId, ImmutableObjects.makeIdOnly(targetType, targetId));
                    continue;
                }
                ((DraftSpi)draft).__unload(propId);
            }
        });
    }

    public static String toString(Object immutable) {
        try {
            return MAPPER.writeValueAsString(immutable);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <I> I fromString(Class<I> type, String json) throws JsonProcessingException {
        return (I)MAPPER.readValue(json, type);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new ImmutableModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        MAPPER = mapper;
    }
}

