/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.converter.ImmutableConverterBuilderImpl;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TypedProp;
import org.jetbrains.annotations.NotNull;

public interface ImmutableConverter<Dynamic, Static> {
    @NotNull
    public Dynamic convert(Static var1);

    public static <Dynamic, Static> Builder<Dynamic, Static> forMethods(Class<Dynamic> immutableType, Class<Static> staticType) {
        return new ImmutableConverterBuilderImpl<Dynamic, Static>(immutableType, staticType, false);
    }

    public static <Dynamic, Static> Builder<Dynamic, Static> forFields(Class<Dynamic> immutableType, Class<Static> staticType) {
        return new ImmutableConverterBuilderImpl<Dynamic, Static>(immutableType, staticType, true);
    }

    public static interface ListMapping<Static, DynamicProp> {
        public ListMapping<Static, DynamicProp> useIf(Predicate<Static> var1);

        public ListMapping<Static, DynamicProp> elementConverter(Function<?, DynamicProp> var1);

        public ListMapping<Static, DynamicProp> nestedConverter(ImmutableConverter<DynamicProp, ?> var1);

        public ListMapping<Static, DynamicProp> defaultElement(DynamicProp var1);

        public ListMapping<Static, DynamicProp> defaultElement(Supplier<DynamicProp> var1);
    }

    public static interface Mapping<Static, DynamicProp> {
        public Mapping<Static, DynamicProp> useIf(Predicate<Static> var1);

        public Mapping<Static, DynamicProp> valueConverter(Function<?, DynamicProp> var1);

        public Mapping<Static, DynamicProp> nestedConverter(ImmutableConverter<DynamicProp, ?> var1);

        public Mapping<Static, DynamicProp> defaultValue(DynamicProp var1);

        public Mapping<Static, DynamicProp> defaultValue(Supplier<DynamicProp> var1);
    }

    public static interface Builder<Dynamic, Static> {
        default public Builder<Dynamic, Static> map(TypedProp<?, ?> prop) {
            return this.map(prop.unwrap(), prop.unwrap().getName(), null);
        }

        default public Builder<Dynamic, Static> map(TypedProp<?, ?> prop, String staticPropName) {
            return this.map(prop.unwrap(), staticPropName, null);
        }

        default public <DynamicProp> Builder<Dynamic, Static> map(TypedProp<Dynamic, DynamicProp> prop, Consumer<Mapping<Static, DynamicProp>> block) {
            return this.map(prop.unwrap(), prop.unwrap().getName(), block);
        }

        default public <DynamicProp> Builder<Dynamic, Static> map(TypedProp<Dynamic, DynamicProp> prop, String staticPropName, Consumer<Mapping<Static, DynamicProp>> block) {
            return this.map(prop.unwrap(), staticPropName, block);
        }

        public Builder<Dynamic, Static> map(ImmutableProp var1, String var2, Consumer<Mapping<Static, ?>> var3);

        default public Builder<Dynamic, Static> mapList(TypedProp.Multiple<?, ?> prop) {
            return this.mapList(prop.unwrap(), prop.unwrap().getName(), null);
        }

        default public Builder<Dynamic, Static> mapList(TypedProp.Multiple<?, ?> prop, String staticPropName) {
            return this.mapList(prop.unwrap(), staticPropName, null);
        }

        default public <DynamicProp> Builder<Dynamic, Static> mapList(TypedProp.Multiple<Dynamic, DynamicProp> prop, Consumer<ListMapping<Static, DynamicProp>> block) {
            return this.mapList(prop.unwrap(), prop.unwrap().getName(), block);
        }

        default public <DynamicProp> Builder<Dynamic, Static> mapList(TypedProp.Multiple<Dynamic, DynamicProp> prop, String staticPropName, Consumer<ListMapping<Static, DynamicProp>> block) {
            return this.mapList(prop.unwrap(), staticPropName, block);
        }

        public Builder<Dynamic, Static> mapList(ImmutableProp var1, String var2, Consumer<ListMapping<Static, ?>> var3);

        default public Builder<Dynamic, Static> unmapStaticProps(String ... staticPropNames) {
            return this.unmapStaticProps(Arrays.asList(staticPropNames));
        }

        public Builder<Dynamic, Static> unmapStaticProps(Collection<String> var1);

        public Builder<Dynamic, Static> setDraftModifier(BiConsumer<Draft, Static> var1);

        public ImmutableConverter<Dynamic, Static> build();
    }
}

