/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.meta.IdGenerator;

public interface ImmutableType {
    public static ImmutableType get(Class<?> javaClass) {
        return Metadata.get(javaClass);
    }

    public static ImmutableType tryGet(Class<?> javaClass) {
        return Metadata.tryGet(javaClass);
    }

    public static Builder newBuilder(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        return Metadata.newTypeBuilder(javaClass, superType, draftFactory);
    }

    public static Builder newBuilder(KClass<?> kotlinClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        return Metadata.newTypeBuilder(kotlinClass, superType, draftFactory);
    }

    public Class<?> getJavaClass();

    public boolean isKotlinClass();

    public boolean isEntity();

    public boolean isMappedSuperclass();

    public boolean isEmbeddable();

    public Annotation getImmutableAnnotation();

    public boolean isAssignableFrom(ImmutableType var1);

    public ImmutableType getSuperType();

    public BiFunction<DraftContext, Object, Draft> getDraftFactory();

    public Map<String, ImmutableProp> getDeclaredProps();

    public ImmutableProp getIdProp();

    public ImmutableProp getVersionProp();

    public Set<ImmutableProp> getKeyProps();

    public String getTableName();

    public Map<String, ImmutableProp> getProps();

    public ImmutableProp getProp(String var1);

    public ImmutableProp getProp(int var1);

    public List<ImmutableProp> getPropChainByColumnName(String var1);

    public Map<String, ImmutableProp> getSelectableProps();

    public Map<String, ImmutableProp> getSelectableReferenceProps();

    public IdGenerator getIdGenerator();

    public static interface Builder {
        public Builder id(int var1, String var2, Class<?> var3);

        public Builder key(int var1, String var2, Class<?> var3);

        public Builder keyReference(int var1, String var2, Class<?> var3, boolean var4);

        public Builder version(int var1, String var2);

        public Builder add(int var1, String var2, ImmutablePropCategory var3, Class<?> var4, boolean var5);

        public Builder add(int var1, String var2, Class<? extends Annotation> var3, Class<?> var4, boolean var5);

        public ImmutableType build();
    }
}

