/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.converter.ImmutableConverterBuilderImpl;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TypedProp;
import org.jetbrains.annotations.NotNull;

public interface ImmutableConverter<T, Static> {
    @NotNull
    public T convert(Static var1);

    public static <T, Static> Builder<T, Static> forMethods(Class<T> immutableType, Class<Static> staticType) {
        return new ImmutableConverterBuilderImpl<T, Static>(immutableType, staticType, false);
    }

    public static <T, Static> Builder<T, Static> forFields(Class<T> immutableType, Class<Static> staticType) {
        return new ImmutableConverterBuilderImpl<T, Static>(immutableType, staticType, true);
    }

    public static interface ListMapping<Static, X, Y> {
        public ListMapping<Static, X, Y> useIf(Predicate<Static> var1);

        public ListMapping<Static, X, Y> elementConverter(Function<X, Y> var1);

        public ListMapping<Static, X, Y> immutableValueConverter(ImmutableConverter<Y, X> var1);

        public ListMapping<Static, X, Y> defaultElement(Y var1);

        public ListMapping<Static, X, Y> defaultElement(Supplier<Y> var1);
    }

    public static interface Mapping<Static, X, Y> {
        public Mapping<Static, X, Y> useIf(Predicate<Static> var1);

        public Mapping<Static, X, Y> valueConverter(Function<X, Y> var1);

        public Mapping<Static, X, Y> immutableValueConverter(ImmutableConverter<Y, X> var1);

        public Mapping<Static, X, Y> defaultValue(Y var1);

        public Mapping<Static, X, Y> defaultValue(Supplier<Y> var1);
    }

    public static interface Builder<T, Static> {
        default public Builder<T, Static> map(TypedProp<?, ?> prop) {
            return this.map(prop.unwrap(), prop.unwrap().getName(), null);
        }

        default public Builder<T, Static> map(TypedProp<?, ?> prop, String staticPropName) {
            return this.map(prop.unwrap(), staticPropName, null);
        }

        default public <Y> Builder<T, Static> map(TypedProp<T, Y> prop, Consumer<Mapping<Static, ?, Y>> block) {
            return this.map(prop.unwrap(), prop.unwrap().getName(), block);
        }

        default public <Y> Builder<T, Static> map(TypedProp<T, Y> prop, String staticPropName, Consumer<Mapping<Static, ?, Y>> block) {
            return this.map(prop.unwrap(), staticPropName, block);
        }

        public Builder<T, Static> map(ImmutableProp var1, String var2, Consumer<Mapping<Static, ?, ?>> var3);

        default public Builder<T, Static> mapList(TypedProp.Multiple<?, ?> prop) {
            return this.mapList(prop.unwrap(), prop.unwrap().getName(), null);
        }

        default public Builder<T, Static> mapList(TypedProp.Multiple<?, ?> prop, String staticPropName) {
            return this.mapList(prop.unwrap(), staticPropName, null);
        }

        default public <Y> Builder<T, Static> mapList(TypedProp.Multiple<T, Y> prop, Consumer<ListMapping<Static, ?, Y>> block) {
            return this.mapList(prop.unwrap(), prop.unwrap().getName(), block);
        }

        default public <Y> Builder<T, Static> mapList(TypedProp.Multiple<T, Y> prop, String staticPropName, Consumer<ListMapping<Static, ?, Y>> block) {
            return this.mapList(prop.unwrap(), staticPropName, block);
        }

        public Builder<T, Static> mapList(ImmutableProp var1, String var2, Consumer<ListMapping<Static, ?, ?>> var3);

        default public Builder<T, Static> unmapStaticProps(String ... staticPropNames) {
            return this.unmapStaticProps(Arrays.asList(staticPropNames));
        }

        public Builder<T, Static> unmapStaticProps(Collection<String> var1);

        public Builder<T, Static> setDraftModifier(BiConsumer<Draft, Static> var1);

        public ImmutableConverter<T, Static> build();
    }
}

