/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.jetbrains.annotations.NotNull;

public abstract class MultipleColumns
implements ColumnDefinition {
    private final String[] arr;
    private final boolean embedded;

    public MultipleColumns(String[] arr, boolean embedded) {
        if (arr.length > 1 && !embedded) {
            throw new IllegalArgumentException("`embedded` must be true where there are several join columns: " + Arrays.toString(arr));
        }
        this.arr = arr;
        this.embedded = embedded;
    }

    @Override
    public boolean isEmbedded() {
        return this.embedded;
    }

    @Override
    public int size() {
        return this.arr.length;
    }

    @Override
    public String name(int index) {
        return this.arr[index];
    }

    @Override
    public int index(String name) {
        int len = this.arr.length;
        for (int i = 0; i < len; ++i) {
            if (!this.arr[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return new Itr(this.arr);
    }

    private static class Itr
    implements Iterator<String> {
        private final String[] arr;
        private int index;

        private Itr(String[] arr) {
            this.arr = arr;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.arr.length;
        }

        @Override
        public String next() {
            if (this.index < this.arr.length) {
                return this.arr[this.index++];
            }
            throw new NoSuchElementException();
        }
    }
}

