/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.ImmutableConverter;
import org.babyfish.jimmer.impl.converter.ImmutableConverterImpl;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;

public class ImmutableConverterBuilderImpl<T, Static>
implements ImmutableConverter.Builder<T, Static> {
    private static final int FULL_AUTO_MAPPING = 1;
    private static final int PARTIAL_AUTO_MAPPING = 2;
    private final ImmutableType immutableType;
    private final Class<Static> staticType;
    private BiConsumer<Draft, Static> draftModifier;
    private Map<ImmutableProp, ImmutableConverterImpl.Field> mappingMap = new HashMap<ImmutableProp, ImmutableConverterImpl.Field>();
    private int autoMapOtherScalars;

    public ImmutableConverterBuilderImpl(Class<T> immutableType, Class<Static> staticType) {
        this.immutableType = ImmutableType.get(immutableType);
        this.staticType = staticType;
    }

    @Override
    public ImmutableConverter.Builder<T, Static> map(ImmutableProp prop, String staticPropName, Consumer<ImmutableConverter.Mapping<Static, ?, ?>> block) {
        this.validateProp(prop);
        this.mapImpl(prop, staticPropName, block, false, false);
        return this;
    }

    @Override
    public ImmutableConverter.Builder<T, Static> mapList(ImmutableProp prop, String staticPropName, Consumer<ImmutableConverter.ListMapping<Static, ?, ?>> block) {
        this.validateProp(prop);
        if (!prop.isReferenceList(TargetLevel.OBJECT) && !prop.isScalarList()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not list property");
        }
        this.mapImpl(prop, staticPropName, block, true, false);
        return this;
    }

    @Override
    public ImmutableConverter.Builder<T, Static> unmap(ImmutableProp ... props) {
        for (ImmutableProp prop : props) {
            this.validateProp(prop);
            this.mappingMap.put(prop, null);
        }
        return this;
    }

    @Override
    public ImmutableConverter.Builder<T, Static> autoMapOtherScalars(boolean partial) {
        this.autoMapOtherScalars = partial ? 2 : 1;
        return this;
    }

    @Override
    public ImmutableConverter.Builder<T, Static> setDraftModifier(BiConsumer<Draft, Static> draftModifier) {
        this.draftModifier = draftModifier;
        return this;
    }

    @Override
    public ImmutableConverter<T, Static> build() {
        if (this.autoMapOtherScalars != 0) {
            for (ImmutableProp prop : this.immutableType.getProps().values()) {
                if (prop.isAssociation(TargetLevel.OBJECT) || this.mappingMap.containsKey(prop)) continue;
                this.mapImpl(prop, prop.getName(), null, prop.isScalarList() || prop.isReferenceList(TargetLevel.OBJECT), true);
            }
        }
        return new ImmutableConverterImpl(this.immutableType, this.staticType, this.mappingMap.values().stream().filter(Objects::nonNull).collect(Collectors.toList()), this.draftModifier);
    }

    private void validateProp(ImmutableProp prop) {
        ImmutableType declaringType = prop.getDeclaringType();
        for (ImmutableType type = this.immutableType; type != null; type = type.getSuperType()) {
            if (declaringType != type) continue;
            return;
        }
        throw new IllegalArgumentException("\"" + prop + "\" is not property of \"" + this.immutableType + "\"");
    }

    private void mapImpl(ImmutableProp prop, String staticPropName, Consumer<?> mappingBuilderConsumer, boolean treatAsList, boolean autoMapping) {
        FieldBuilder builder;
        ArrayList<String> methodNames = new ArrayList<String>();
        String suffix = Character.toUpperCase(staticPropName.charAt(0)) + staticPropName.substring(1);
        if (prop.getElementClass() == Boolean.TYPE) {
            methodNames.add("is" + suffix);
        }
        methodNames.add("get" + suffix);
        methodNames.add(staticPropName);
        Method method = null;
        Field field = null;
        block4: for (String methodName : methodNames) {
            for (Class<Static> type = this.staticType; type != null; type = type.getSuperclass()) {
                try {
                    method = this.staticType.getDeclaredMethod(methodName, new Class[0]);
                    if (Modifier.isStatic(method.getModifiers())) {
                        method = null;
                        continue;
                    }
                    method.setAccessible(true);
                    continue block4;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        if (method == null) {
            for (Class<Static> type = this.staticType; type != null; type = type.getSuperclass()) {
                try {
                    field = this.staticType.getDeclaredField(staticPropName);
                    if (Modifier.isStatic(field.getModifiers())) {
                        field = null;
                        continue;
                    }
                    field.setAccessible(true);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (method == null && field == null) {
            if (autoMapping && this.autoMapOtherScalars == 2) {
                return;
            }
            throw new IllegalArgumentException((autoMapping ? "Cannot automatically map the property \"" + prop + "\"" : "Illegal static property name: \"" + staticPropName + '\"') + ", the static type \"" + this.staticType.getName() + "\" has neither methods " + methodNames.stream().map((? super T it) -> '\"' + it + "()\"").collect(Collectors.joining(", ")) + " nor field \"" + staticPropName + "\"");
        }
        FieldBuilder fieldBuilder = builder = treatAsList ? new ListMappingImpl(prop, method, field, autoMapping) : new MappingImpl(prop, method, field, autoMapping);
        if (mappingBuilderConsumer != null) {
            mappingBuilderConsumer.accept(builder);
        }
        this.mappingMap.put(prop, builder.build());
    }

    private static class ListMappingImpl<Static, X, Y>
    implements ImmutableConverter.ListMapping<Static, X, Y>,
    FieldBuilder {
        private final ImmutableProp prop;
        private final Method method;
        private final Field field;
        private final boolean autoMapping;
        private Predicate<?> cond;
        protected Function<?, ?> elementConverter;
        private Supplier<?> defaultElementSupplier;

        private ListMappingImpl(ImmutableProp prop, Method method, Field field, boolean autoMapping) {
            this.prop = prop;
            this.method = method;
            this.field = field;
            this.autoMapping = autoMapping;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, X, Y> useIf(Predicate<Static> cond) {
            this.cond = cond;
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, X, Y> elementConverter(Function<X, Y> elementConverter) {
            this.elementConverter = new ListConverter(elementConverter);
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, X, Y> immutableValueConverter(ImmutableConverter<Y, X> elementConverter) {
            this.elementConverter(value -> elementConverter.convert(value));
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, X, Y> defaultElement(Y defaultElement) {
            this.defaultElementSupplier = () -> defaultElement;
            return this;
        }

        @Override
        public ImmutableConverter.ListMapping<Static, X, Y> defaultElement(Supplier<Y> defaultElementSupplier) {
            this.defaultElementSupplier = defaultElementSupplier;
            return this;
        }

        @Override
        public ImmutableConverterImpl.Field build() {
            return ImmutableConverterImpl.Field.create(this.cond, this.prop, this.method, this.field, this.elementConverter, this.defaultElementSupplier, this.autoMapping);
        }

        private class ListConverter<X, Y>
        implements Function<List<X>, List<Y>> {
            private final Function<X, Y> elementConverter;

            private ListConverter(Function<X, Y> elementConverter) {
                this.elementConverter = elementConverter;
            }

            @Override
            public List<Y> apply(List<X> list) {
                ArrayList<X> newList = new ArrayList<X>(list.size());
                for (X x : list) {
                    Object y = x == null ? (ListMappingImpl.this.defaultElementSupplier == null ? null : ListMappingImpl.this.defaultElementSupplier.get()) : (this.elementConverter == null ? x : this.elementConverter.apply(x));
                    newList.add(y);
                }
                return newList;
            }
        }
    }

    private static class MappingImpl<Static, X, Y>
    implements ImmutableConverter.Mapping<Static, X, Y>,
    FieldBuilder {
        private final ImmutableProp prop;
        private final Method method;
        private final Field field;
        private final boolean autoMapping;
        private Predicate<?> cond;
        protected Function<?, ?> valueConverter;
        private Supplier<?> defaultValueSupplier;

        private MappingImpl(ImmutableProp prop, Method method, Field field, boolean autoMapping) {
            this.prop = prop;
            this.method = method;
            this.field = field;
            this.autoMapping = autoMapping;
        }

        @Override
        public ImmutableConverter.Mapping<Static, X, Y> useIf(Predicate<Static> cond) {
            this.cond = cond;
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, X, Y> valueConverter(Function<X, Y> valueConverter) {
            this.valueConverter = valueConverter;
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, X, Y> immutableValueConverter(ImmutableConverter<Y, X> valueConverter) {
            this.valueConverter(value -> valueConverter.convert(value));
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, X, Y> defaultValue(Y defaultValue) {
            this.defaultValueSupplier = () -> defaultValue;
            return this;
        }

        @Override
        public ImmutableConverter.Mapping<Static, X, Y> defaultValue(Supplier<Y> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
            return this;
        }

        @Override
        public ImmutableConverterImpl.Field build() {
            return ImmutableConverterImpl.Field.create(this.cond, this.prop, this.method, this.field, this.valueConverter, this.defaultValueSupplier, this.autoMapping);
        }
    }

    private static interface FieldBuilder {
        public ImmutableConverterImpl.Field build();
    }
}

