/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;

public class StaticCache<K, V> {
    private final Function<K, V> creator;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Map<K, V> positiveCacheMap = new HashMap();
    private Map<K, Void> negativeCacheMap;

    public StaticCache(Function<K, V> creator) {
        this(creator, true);
    }

    public StaticCache(Function<K, V> creator, boolean nullable) {
        this.creator = creator;
        if (nullable) {
            this.negativeCacheMap = new LRUMap<K, Void>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V value;
        block14: {
            Lock lock = this.cacheLock.readLock();
            lock.lock();
            try {
                if (this.negativeCacheMap != null && this.negativeCacheMap.containsKey(key)) {
                    V v = null;
                    return v;
                }
                value = this.positiveCacheMap.get(key);
            }
            finally {
                lock.unlock();
            }
            if (value == null) {
                lock = this.cacheLock.writeLock();
                lock.lock();
                try {
                    if (this.negativeCacheMap != null && this.negativeCacheMap.containsKey(key)) {
                        V v = null;
                        return v;
                    }
                    value = this.positiveCacheMap.get(key);
                    if (value != null) break block14;
                    value = this.creator.apply(key);
                    if (value != null) {
                        this.positiveCacheMap.put(key, value);
                        break block14;
                    }
                    if (this.negativeCacheMap != null) {
                        this.negativeCacheMap.put(key, null);
                        break block14;
                    }
                    throw new IllegalStateException("The creator cannot return null because current static cache does not accept null values");
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return value;
    }

    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        LRUMap() {
            super(171, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return true;
        }
    }
}

