/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.ImmutableTypeImpl;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.meta.impl.RedirectedProp;
import org.babyfish.jimmer.meta.impl.Storages;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OnDissociate;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.OrderedProp;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.meta.Storage;
import org.jetbrains.annotations.NotNull;

class ImmutablePropImpl
implements ImmutableProp {
    private final ImmutableTypeImpl declaringType;
    private final int id;
    private final String name;
    private final ImmutablePropCategory category;
    private final Class<?> elementClass;
    private final boolean nullable;
    private KProperty1<?, ?> kotlinProp;
    private Method javaGetter;
    private Annotation associationAnnotation;
    private final boolean isTransient;
    private final boolean hasTransientResolver;
    private final DissociateAction dissociateAction;
    private Storage storage;
    private boolean storageResolved;
    private ImmutableTypeImpl targetType;
    private boolean targetTypeResolved;
    private List<OrderedItem> orderedItems;
    private ImmutableProp mappedBy;
    private ImmutableProp acceptedMappedBy;
    private boolean mappedByResolved;
    private ImmutableProp opposite;
    private boolean oppositeResolved;

    ImmutablePropImpl(ImmutableTypeImpl declaringType, int id, String name, ImmutablePropCategory category, Class<?> elementClass, boolean nullable, Class<? extends Annotation> associationType) {
        OnDissociate onDissociate;
        this.declaringType = declaringType;
        this.id = id;
        this.name = name;
        this.category = category;
        this.elementClass = elementClass;
        this.nullable = nullable;
        KClass<?> kotlinClass = declaringType.getKotlinClass();
        if (kotlinClass != null) {
            this.kotlinProp = KClasses.getDeclaredMemberProperties(kotlinClass).stream().filter(it -> name.equals(it.getName())).findFirst().get();
        }
        try {
            this.javaGetter = declaringType.getJavaClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.javaGetter = declaringType.getJavaClass().getDeclaredMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.javaGetter = declaringType.getJavaClass().getDeclaredMethod("is" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
            if (this.javaGetter.getReturnType() != Boolean.TYPE) {
                this.javaGetter = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (this.javaGetter == null) {
            throw new AssertionError((Object)("Internal bug: Cannot find the getter of prop \"" + name + "\" of the interface \"" + declaringType.getJavaClass().getName() + "\""));
        }
        Transient trans = this.getAnnotation(Transient.class);
        this.isTransient = trans != null;
        boolean bl = this.hasTransientResolver = trans != null && trans.value() != Void.TYPE;
        if (associationType != null) {
            this.associationAnnotation = this.getAnnotation(associationType);
        }
        if ((onDissociate = this.getAnnotation(OnDissociate.class)) != null) {
            if (category != ImmutablePropCategory.REFERENCE) {
                throw new ModelException("Illegal property \"" + this + "\", only reference property can be decorated by @OnDissociate");
            }
            this.dissociateAction = onDissociate.value();
        } else {
            this.dissociateAction = DissociateAction.NONE;
        }
    }

    @Override
    @NotNull
    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ImmutablePropCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public boolean isScalar() {
        return this.category == ImmutablePropCategory.SCALAR;
    }

    @Override
    public boolean isScalarList() {
        return this.category == ImmutablePropCategory.SCALAR_LIST;
    }

    @Override
    public boolean isAssociation(TargetLevel level) {
        return this.category.isAssociation() && (level == TargetLevel.OBJECT || !this.isTransient);
    }

    @Override
    public boolean isReference(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE && (level == TargetLevel.OBJECT || !this.isTransient);
    }

    @Override
    public boolean isReferenceList(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE_LIST && (level == TargetLevel.OBJECT || !this.isTransient);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Annotation annotation;
        if (this.kotlinProp != null && (annotation = (Annotation)this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).findFirst().orElse(null)) != null) {
            return (A)annotation;
        }
        return this.javaGetter.getAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        Annotation[] getterArr = this.javaGetter.getAnnotationsByType(annotationType);
        Annotation[] propArr = null;
        if (this.kotlinProp != null) {
            propArr = (Annotation[])this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).toArray();
        }
        if (propArr == null && propArr.length == 0) {
            return getterArr;
        }
        Annotation[] mergedArr = (Annotation[])new Object[propArr.length + getterArr.length];
        System.arraycopy(propArr, 0, mergedArr, 0, propArr.length);
        System.arraycopy(getterArr, 0, mergedArr, propArr.length, getterArr.length);
        return mergedArr;
    }

    @Override
    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean hasTransientResolver() {
        return this.hasTransientResolver;
    }

    @Override
    @NotNull
    public DissociateAction getDissociateAction() {
        return this.dissociateAction;
    }

    @Override
    public <S extends Storage> S getStorage() {
        if (this.storageResolved) {
            return (S)this.storage;
        }
        this.storage = Storages.of(this);
        this.storageResolved = true;
        return (S)this.storage;
    }

    @Override
    public boolean isId() {
        return this == this.declaringType.getIdProp();
    }

    @Override
    public boolean isVersion() {
        return this == this.declaringType.getVersionProp();
    }

    @Override
    public ImmutableType getTargetType() {
        if (this.targetTypeResolved) {
            return this.targetType;
        }
        if (this.isAssociation(TargetLevel.OBJECT)) {
            this.targetType = Metadata.tryGet(this.elementClass);
            if (this.targetType == null) {
                throw new ModelException("Cannot resolve target type of \"" + this + "\"");
            }
        }
        this.targetTypeResolved = true;
        return this.targetType;
    }

    @Override
    public List<OrderedItem> getOrderedItems() {
        List<OrderedItem> orderedItems = this.orderedItems;
        if (orderedItems == null) {
            OrderedProp[] orderedProps = null;
            if (this.isReferenceList(TargetLevel.ENTITY)) {
                OneToMany oneToMany = this.getAnnotation(OneToMany.class);
                if (oneToMany != null) {
                    orderedProps = oneToMany.orderedProps();
                } else {
                    ManyToMany manyToMany = this.getAnnotation(ManyToMany.class);
                    if (manyToMany != null) {
                        orderedProps = manyToMany.orderedProps();
                    }
                }
            }
            if (orderedProps == null || orderedProps.length == 0) {
                orderedItems = Collections.emptyList();
            } else {
                ImmutableType targetType = this.getTargetType();
                LinkedHashMap<String, OrderedItem> map = new LinkedHashMap<String, OrderedItem>((orderedProps.length * 4 + 2) / 3);
                for (OrderedProp orderedProp : orderedProps) {
                    if (map.containsKey(orderedProp.value())) {
                        throw new ModelException("Illegal property \"" + this + "\", duplicated ordered property \"" + orderedProp.value() + "\"");
                    }
                    ImmutableProp prop = targetType.getProp(orderedProp.value());
                    if (prop == null) {
                        throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + orderedProp.value() + "\" is not declared in target type \"" + targetType + "\"");
                    }
                    if (!prop.isScalar()) {
                        throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + prop + "\" is not scalar field");
                    }
                    map.put(orderedProp.value(), new OrderedItem(prop, orderedProp.desc()));
                }
                orderedItems = Collections.unmodifiableList(new ArrayList(map.values()));
            }
            this.orderedItems = orderedItems;
        }
        return orderedItems;
    }

    @Override
    public ImmutableProp getMappedBy() {
        if (this.mappedByResolved) {
            return this.mappedBy;
        }
        if (this.isAssociation(TargetLevel.ENTITY)) {
            String mappedBy = "";
            OneToOne oneToOne = this.getAnnotation(OneToOne.class);
            if (oneToOne != null) {
                mappedBy = oneToOne.mappedBy();
            }
            if (mappedBy.isEmpty()) {
                ManyToMany manyToMany;
                OneToMany oneToMany = this.getAnnotation(OneToMany.class);
                if (oneToMany != null) {
                    mappedBy = oneToMany.mappedBy();
                }
                if (mappedBy.isEmpty() && (manyToMany = this.getAnnotation(ManyToMany.class)) != null) {
                    mappedBy = manyToMany.mappedBy();
                }
            }
            if (!mappedBy.isEmpty()) {
                ImmutableProp resolved = this.getTargetType().getProps().get(mappedBy);
                if (resolved == null) {
                    throw new ModelException("Cannot resolve the mappedBy property name \"" + mappedBy + "\" for property \"" + this + "\"");
                }
                if (resolved.getStorage() == null) {
                    throw new ModelException("The property \"" + resolved + "\" is illegal, it's not persistence property so that \"this\" cannot reference it by \"mappedBy\"");
                }
                if (resolved.getAssociationAnnotation().annotationType() == OneToOne.class && this.associationAnnotation.annotationType() != OneToOne.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
                }
                if (resolved.getAssociationAnnotation().annotationType() == ManyToOne.class && this.associationAnnotation.annotationType() != OneToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
                }
                if (resolved.isReferenceList(TargetLevel.ENTITY) && this.associationAnnotation.annotationType() != ManyToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be many-to-many property because its \"mappedBy\" property \"" + resolved + "\" is list");
                }
                ((ImmutablePropImpl)resolved).acceptMappedBy(this);
                this.mappedBy = resolved;
            }
        }
        this.mappedByResolved = true;
        return this.mappedBy;
    }

    private void acceptMappedBy(ImmutableProp prop) {
        if (this.acceptedMappedBy != null) {
            throw new ModelException("Both `" + this.acceptedMappedBy + "` and `" + prop + "` use `mappedBy` to reference `" + this + "`");
        }
        this.acceptedMappedBy = prop;
    }

    @Override
    public ImmutableProp getOpposite() {
        if (this.oppositeResolved) {
            return this.opposite;
        }
        if (this.isAssociation(TargetLevel.ENTITY)) {
            this.opposite = this.getMappedBy();
            if (this.opposite == null) {
                for (ImmutableProp backProp : this.getTargetType().getProps().values()) {
                    if (backProp.getMappedBy() != this) continue;
                    this.opposite = backProp;
                    break;
                }
            }
        }
        this.oppositeResolved = true;
        return this.opposite;
    }

    public boolean equals(Object o) {
        return o instanceof ImmutableProp && this == RedirectedProp.unwrap((ImmutableProp)o);
    }

    public String toString() {
        return this.declaringType.toString() + '.' + this.name;
    }
}

