/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.meta.Storage;
import org.jetbrains.annotations.NotNull;

public class RedirectedProp
implements ImmutableProp {
    private final ImmutableProp raw;
    private final ImmutableType sourceType;
    private final ImmutableType targetType;

    private RedirectedProp(ImmutableProp prop, ImmutableType sourceType, ImmutableType targetType) {
        this.raw = RedirectedProp.unwrap(prop);
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public static ImmutableProp source(ImmutableProp prop, Class<?> sourceType) {
        return RedirectedProp.source(prop, ImmutableType.get(sourceType));
    }

    public static ImmutableProp source(ImmutableProp prop, ImmutableType sourceType) {
        if (prop == null) {
            return null;
        }
        if (!prop.getDeclaringType().isAssignableFrom(sourceType)) {
            throw new IllegalArgumentException("Cannot redirect source type of \"" + prop + "\" to \"" + sourceType + "\" because that class not derived type of \"" + prop.getDeclaringType() + "\"");
        }
        if (prop.getDeclaringType() == sourceType) {
            return prop;
        }
        return new RedirectedProp(prop, sourceType, prop.getTargetType());
    }

    public static ImmutableProp target(ImmutableProp prop, Class<?> targetType) {
        return RedirectedProp.target(prop, ImmutableType.get(targetType));
    }

    public static ImmutableProp target(ImmutableProp prop, ImmutableType targetType) {
        if (prop == null) {
            return null;
        }
        if (prop.getTargetType() == null) {
            throw new IllegalArgumentException("Cannot redirect target type of \"" + prop + "\" because it is not association property\"");
        }
        if (!prop.getTargetType().isAssignableFrom(targetType)) {
            throw new IllegalArgumentException("Cannot redirect target type of \"" + prop + "\" to \"" + targetType + "\" because that class not derived type of \"" + prop.getTargetType() + "\"");
        }
        if (prop.getTargetType() == targetType) {
            return prop;
        }
        return new RedirectedProp(prop, prop.getDeclaringType(), targetType);
    }

    @Override
    public ImmutableType getDeclaringType() {
        return this.sourceType;
    }

    @Override
    public ImmutableType getTargetType() {
        return this.targetType;
    }

    @Override
    public int getId() {
        return this.raw.getId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.raw.getName();
    }

    @Override
    @NotNull
    public ImmutablePropCategory getCategory() {
        return this.raw.getCategory();
    }

    @Override
    @NotNull
    public Class<?> getElementClass() {
        return this.raw.getElementClass();
    }

    @Override
    public boolean isScalar() {
        return this.raw.isScalar();
    }

    @Override
    public boolean isScalarList() {
        return this.raw.isScalarList();
    }

    @Override
    public boolean isAssociation(TargetLevel level) {
        return this.raw.isAssociation(level);
    }

    @Override
    public boolean isReference(TargetLevel level) {
        return this.raw.isReference(level);
    }

    @Override
    public boolean isReferenceList(TargetLevel level) {
        return this.raw.isReferenceList(level);
    }

    @Override
    public boolean isNullable() {
        return this.raw.isNullable();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.raw.getAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        return this.raw.getAnnotations(annotationType);
    }

    @Override
    public Annotation getAssociationAnnotation() {
        return this.raw.getAssociationAnnotation();
    }

    @Override
    public boolean isTransient() {
        return this.raw.isTransient();
    }

    @Override
    public boolean hasTransientResolver() {
        return this.raw.hasTransientResolver();
    }

    @Override
    @NotNull
    public DissociateAction getDissociateAction() {
        return this.raw.getDissociateAction();
    }

    @Override
    public <S extends Storage> S getStorage() {
        return this.raw.getStorage();
    }

    @Override
    public boolean isId() {
        return this.raw.isId();
    }

    @Override
    public boolean isVersion() {
        return this.raw.isVersion();
    }

    @Override
    public List<OrderedItem> getOrderedItems() {
        return this.raw.getOrderedItems();
    }

    @Override
    public ImmutableProp getMappedBy() {
        return this.raw.getMappedBy();
    }

    @Override
    public ImmutableProp getOpposite() {
        return this.raw.getOpposite();
    }

    public int hashCode() {
        return System.identityHashCode(this.raw);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableProp)) {
            return false;
        }
        return this.raw == RedirectedProp.unwrap((ImmutableProp)o);
    }

    public String toString() {
        return this.sourceType + "." + this.raw.getName();
    }

    static ImmutableProp unwrap(ImmutableProp prop) {
        return prop instanceof RedirectedProp ? ((RedirectedProp)prop).raw : prop;
    }
}

