/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.BiFunction;
import kotlin.reflect.KClass;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.impl.ImmutableTypeImpl;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.util.StaticCache;

public class Metadata {
    private static final Class<?> TABLE_CLASS;
    private static final StaticCache<Class<?>, ImmutableTypeImpl> CACHE;

    private Metadata() {
    }

    public static ImmutableTypeImpl get(Class<?> javaClass) {
        ImmutableTypeImpl immutableType = CACHE.get(javaClass);
        if (immutableType == null) {
            throw new IllegalArgumentException("Cannot get immutable type for \"" + javaClass.getName() + "\"");
        }
        return immutableType;
    }

    public static ImmutableTypeImpl tryGet(Class<?> javaClass) {
        return CACHE.get(javaClass);
    }

    private static ImmutableTypeImpl create(Class<?> javaClass) {
        Field typeField;
        Class<?> draftClass;
        Class<?> immutableJavaClass;
        if (TABLE_CLASS != null && TABLE_CLASS.isAssignableFrom(javaClass)) {
            if (javaClass.getTypeParameters().length != 0) {
                return null;
            }
            Type type = (Type)TypeUtils.getTypeArguments(javaClass, TABLE_CLASS).values().iterator().next();
            if (!(type instanceof Class)) {
                return null;
            }
            javaClass = (Class)type;
        }
        if ((immutableJavaClass = Metadata.getImmutableJavaClass(javaClass)) == null) {
            return null;
        }
        try {
            draftClass = Class.forName(immutableJavaClass.getName() + "Draft", true, immutableJavaClass.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot find draft type for \"" + immutableJavaClass.getName() + "\"");
        }
        Class producerClass = Arrays.stream(draftClass.getDeclaredClasses()).filter(it -> it.getSimpleName().equals("Producer") || it.getSimpleName().equals("$")).findFirst().orElse(null);
        if (producerClass == null) {
            throw new IllegalArgumentException("Cannot find producer type for \"" + draftClass.getName() + "\"");
        }
        if (producerClass.getSimpleName().equals("$")) {
            Object owner;
            try {
                Field ownerField = producerClass.getField("INSTANCE");
                owner = ownerField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                owner = null;
            }
            Method method = null;
            if (owner != null) {
                try {
                    method = owner.getClass().getMethod("getType", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (owner == null || method == null) {
                throw new IllegalArgumentException("Cannot find immutable type from illegal producer type \"" + producerClass.getName() + "\"");
            }
            try {
                return (ImmutableTypeImpl)method.invoke(owner, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError("Internal bug: Cannot access " + method, ex);
            }
            catch (InvocationTargetException ex) {
                throw new AssertionError("Internal bug: Cannot get value from " + method, ex);
            }
        }
        try {
            typeField = producerClass.getField("TYPE");
        }
        catch (NoSuchFieldException ex) {
            typeField = null;
        }
        if (typeField == null || typeField.getType() != ImmutableType.class) {
            throw new IllegalArgumentException("Cannot find immutable type from illegal producer type \"" + producerClass.getName() + "\"");
        }
        try {
            return (ImmutableTypeImpl)typeField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Internal bug: Cannot access " + typeField));
        }
    }

    public static ImmutableType.Builder newTypeBuilder(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        return new ImmutableTypeImpl.BuilderImpl(javaClass, superType, draftFactory);
    }

    public static ImmutableType.Builder newTypeBuilder(KClass<?> kotlinClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        return new ImmutableTypeImpl.BuilderImpl(kotlinClass, superType, draftFactory);
    }

    private static Class<?> getImmutableJavaClass(Class<?> javaClass) {
        Class<?> immutableJavaClass;
        boolean matched = Arrays.stream(javaClass.getAnnotations()).anyMatch(it -> it.annotationType() == Immutable.class || it.annotationType() == Entity.class || it.annotationType() == MappedSuperclass.class);
        if (matched) {
            return javaClass;
        }
        Class<?> superClass = javaClass.getSuperclass();
        if (superClass != null && superClass != Object.class && (immutableJavaClass = Metadata.getImmutableJavaClass(superClass)) != null) {
            return immutableJavaClass;
        }
        for (Class<?> interfaceClass : javaClass.getInterfaces()) {
            Class<?> immutableJavaClass2 = Metadata.getImmutableJavaClass(interfaceClass);
            if (immutableJavaClass2 == null) continue;
            return immutableJavaClass2;
        }
        return null;
    }

    static {
        Class<?> tableClass;
        CACHE = new StaticCache<Class, ImmutableTypeImpl>(Metadata::create);
        try {
            tableClass = Class.forName("org.babyfish.jimmer.sql.ast.table.Table");
        }
        catch (ClassNotFoundException ex) {
            tableClass = null;
        }
        TABLE_CLASS = tableClass;
    }
}

