/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.meta.Storage;
import org.jetbrains.annotations.NotNull;

public abstract class RedirectedProp
implements ImmutableProp {
    protected final ImmutableProp raw;

    RedirectedProp(ImmutableProp raw) {
        this.raw = raw;
    }

    public static ImmutableProp source(ImmutableProp prop, ImmutableType sourceType) {
        if (prop.getDeclaringType() == sourceType) {
            return prop;
        }
        return new SourceRedirectedProp(prop, sourceType);
    }

    public static ImmutableProp target(ImmutableProp prop, ImmutableType targetType) {
        if (prop.getTargetType() == targetType) {
            return prop;
        }
        return new TargetRedirectedProp(prop, targetType);
    }

    @Override
    @NotNull
    public ImmutableType getDeclaringType() {
        return this.raw.getDeclaringType();
    }

    @Override
    public int getId() {
        return this.raw.getId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.raw.getName();
    }

    @Override
    @NotNull
    public ImmutablePropCategory getCategory() {
        return this.raw.getCategory();
    }

    @Override
    @NotNull
    public Class<?> getElementClass() {
        return this.raw.getElementClass();
    }

    @Override
    public boolean isScalar() {
        return this.raw.isScalar();
    }

    @Override
    public boolean isScalarList() {
        return this.raw.isScalarList();
    }

    @Override
    public boolean isAssociation(TargetLevel level) {
        return this.raw.isAssociation(level);
    }

    @Override
    public boolean isReference(TargetLevel level) {
        return this.raw.isReference(level);
    }

    @Override
    public boolean isReferenceList(TargetLevel level) {
        return this.raw.isReferenceList(level);
    }

    @Override
    public boolean isNullable() {
        return this.raw.isNullable();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.raw.getAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        return this.raw.getAnnotations(annotationType);
    }

    @Override
    public Annotation getAssociationAnnotation() {
        return this.raw.getAssociationAnnotation();
    }

    @Override
    public boolean isTransient() {
        return this.raw.isTransient();
    }

    @Override
    public boolean hasTransientResolver() {
        return this.raw.hasTransientResolver();
    }

    @Override
    @NotNull
    public DissociateAction getDissociateAction() {
        return this.raw.getDissociateAction();
    }

    @Override
    public <S extends Storage> S getStorage() {
        return this.raw.getStorage();
    }

    @Override
    public boolean isId() {
        return this.raw.isId();
    }

    @Override
    public boolean isVersion() {
        return this.raw.isVersion();
    }

    @Override
    public ImmutableType getTargetType() {
        return this.raw.getTargetType();
    }

    @Override
    public List<OrderedItem> getOrderedItems() {
        return this.raw.getOrderedItems();
    }

    @Override
    public ImmutableProp getMappedBy() {
        return this.raw.getMappedBy();
    }

    @Override
    public ImmutableProp getOpposite() {
        return this.raw.getOpposite();
    }

    private static class SourceRedirectedProp
    extends RedirectedProp {
        private final ImmutableType sourceType;

        private SourceRedirectedProp(ImmutableProp raw, ImmutableType sourceType) {
            super(raw);
            if (!raw.getDeclaringType().isAssignableFrom(sourceType)) {
                throw new IllegalArgumentException("Cannot redirect source type of \"" + raw + "\" to \"" + sourceType + "\" because that class not derived type of \"" + raw.getDeclaringType() + "\"");
            }
            this.sourceType = sourceType;
        }

        @Override
        @NotNull
        public ImmutableType getDeclaringType() {
            return this.sourceType;
        }

        public int hashCode() {
            return this.raw.hashCode() ^ this.sourceType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SourceRedirectedProp)) {
                return false;
            }
            SourceRedirectedProp other = (SourceRedirectedProp)obj;
            return this.raw.equals(other.raw) && this.sourceType.equals(other.sourceType);
        }

        public String toString() {
            return this.sourceType + "." + this.raw.getName();
        }
    }

    private static class TargetRedirectedProp
    extends RedirectedProp {
        private final ImmutableType targetType;

        private TargetRedirectedProp(ImmutableProp raw, ImmutableType targetType) {
            super(raw);
            if (!raw.getTargetType().isAssignableFrom(targetType)) {
                throw new IllegalArgumentException("Cannot redirect target type of \"" + raw + "\" to \"" + targetType + "\" because that class not derived type of \"" + raw.getTargetType() + "\"");
            }
            this.targetType = targetType;
        }

        @Override
        public ImmutableType getTargetType() {
            return this.targetType;
        }

        public int hashCode() {
            return this.raw.hashCode() ^ this.targetType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TargetRedirectedProp)) {
                return false;
            }
            TargetRedirectedProp other = (TargetRedirectedProp)obj;
            return this.raw.equals(other.raw) && this.targetType.equals(other.targetType);
        }

        public String toString() {
            return this.raw.toString();
        }
    }
}

