/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;

public class TypedPropImpl<S, T>
implements TypedProp<S, T> {
    protected final ImmutableProp prop;

    protected TypedPropImpl(ImmutableProp prop) {
        if (prop instanceof TypedProp) {
            throw new IllegalArgumentException("TypedProp can only wrap raw prop");
        }
        this.prop = prop;
    }

    public String toString() {
        return this.prop.toString();
    }

    @Override
    public ImmutableProp unwrap() {
        return this.prop;
    }

    public static class ReferenceList<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.ReferenceList<S, T> {
        public ReferenceList(ImmutableProp prop) {
            super(prop);
            if (!prop.isReferenceList(TargetLevel.OBJECT)) {
                throw new IllegalArgumentException("\"" + prop + "\" is not reference list property");
            }
        }
    }

    public static class Reference<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.Reference<S, T> {
        public Reference(ImmutableProp prop) {
            super(prop);
            if (!prop.isReference(TargetLevel.OBJECT)) {
                throw new IllegalArgumentException("\"" + prop + "\" is not reference property");
            }
        }
    }

    public static class ScalarList<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.ScalarList<S, T> {
        public ScalarList(ImmutableProp prop) {
            super(prop);
            if (!prop.isScalarList()) {
                throw new IllegalArgumentException("\"" + prop + "\" is not scalar list property");
            }
        }
    }

    public static class Scalar<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.Scalar<S, T> {
        public Scalar(ImmutableProp prop) {
            super(prop);
            if (!prop.isScalar()) {
                throw new IllegalArgumentException("\"" + prop + "\" is not scalar property");
            }
        }

        @Override
        public TypedProp.Scalar<S, T> asc() {
            return this;
        }

        @Override
        public TypedProp.Scalar<S, T> desc() {
            return new Desc(this.prop);
        }

        static class Desc<S, T>
        extends Scalar<S, T>
        implements TypedProp.Scalar.Desc<S, T> {
            public Desc(ImmutableProp prop) {
                super(prop);
            }

            @Override
            public TypedProp.Scalar<S, T> asc() {
                return new Scalar(this.prop);
            }

            @Override
            public TypedProp.Scalar<S, T> desc() {
                return this;
            }
        }
    }
}

