/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.meta.IdGenerator;

public interface ImmutableType {
    public static ImmutableType get(Class<?> javaClass) {
        return Metadata.get(javaClass);
    }

    public static ImmutableType tryGet(Class<?> javaClass) {
        return Metadata.tryGet(javaClass);
    }

    public static Builder newBuilder(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        return Metadata.newTypeBuilder(javaClass, superType, draftFactory);
    }

    public static Builder newBuilder(KClass<?> kotlinClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        return Metadata.newTypeBuilder(kotlinClass, superType, draftFactory);
    }

    public Class<?> getJavaClass();

    public ImmutableType getSuperType();

    public BiFunction<DraftContext, Object, Draft> getDraftFactory();

    public Map<String, ImmutableProp> getDeclaredProps();

    public ImmutableProp getIdProp();

    public ImmutableProp getVersionProp();

    public Set<ImmutableProp> getKeyProps();

    public String getTableName();

    public Map<String, ImmutableProp> getProps();

    public ImmutableProp getProp(String var1);

    public ImmutableProp getProp(int var1);

    public ImmutableProp getPropByColumnName(String var1);

    public Map<String, ImmutableProp> getSelectableProps();

    public IdGenerator getIdGenerator();

    public static interface Builder {
        public Builder id(String var1, Class<?> var2);

        public Builder key(String var1, Class<?> var2);

        public Builder keyReference(String var1, Class<?> var2, boolean var3);

        public Builder version(String var1);

        public Builder add(String var1, ImmutablePropCategory var2, Class<?> var3, boolean var4);

        public Builder add(String var1, Class<? extends Annotation> var2, Class<?> var3, boolean var4);

        public ImmutableType build();
    }
}

