/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.jvm.internal.ClassBasedDeclarationContainer;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.impl.ImmutablePropImpl;
import org.babyfish.jimmer.meta.impl.Utils;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.GeneratedValue;
import org.babyfish.jimmer.sql.GenerationType;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.Table;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.SequenceIdGenerator;

class ImmutableTypeImpl
implements ImmutableType {
    private Class<?> javaClass;
    private KClass<?> kotlinClass;
    private ImmutableType superType;
    private BiFunction<DraftContext, Object, Draft> draftFactory;
    private Map<String, ImmutableProp> declaredProps = new LinkedHashMap<String, ImmutableProp>();
    private Map<String, ImmutableProp> props;
    private Map<String, ImmutableProp> selectableProps;
    private ImmutableProp idProp;
    private ImmutableProp versionProp;
    private Set<ImmutableProp> keyProps = Collections.emptySet();
    private IdGenerator idGenerator;
    private String tableName;
    private static final String SEQUENCE_PREFIX = "sequence:";

    ImmutableTypeImpl(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        this.javaClass = javaClass;
        this.superType = superType;
        this.draftFactory = draftFactory;
        Table table = javaClass.getAnnotation(Table.class);
        String string = this.tableName = table != null ? table.name() : "";
        if (this.tableName.isEmpty()) {
            this.tableName = Utils.databaseIdentifier(javaClass.getSimpleName());
        }
    }

    ImmutableTypeImpl(KClass<?> kotlinClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        this(((ClassBasedDeclarationContainer)kotlinClass).getJClass(), superType, draftFactory);
        this.kotlinClass = kotlinClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    KClass<?> getKotlinClass() {
        return this.kotlinClass;
    }

    @Override
    public ImmutableType getSuperType() {
        return this.superType;
    }

    @Override
    public BiFunction<DraftContext, Object, Draft> getDraftFactory() {
        return this.draftFactory;
    }

    @Override
    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    @Override
    public ImmutableProp getIdProp() {
        return this.idProp;
    }

    @Override
    public ImmutableProp getVersionProp() {
        return this.versionProp;
    }

    @Override
    public Set<ImmutableProp> getKeyProps() {
        return this.keyProps;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Map<String, ImmutableProp> getProps() {
        Map<String, ImmutableProp> props = this.props;
        if (props == null) {
            if (this.superType == null) {
                props = this.declaredProps;
            } else {
                props = new LinkedHashMap<String, ImmutableProp>(this.superType.getProps());
                for (ImmutableProp declaredProp : this.declaredProps.values()) {
                    if (props.put(declaredProp.getName(), declaredProp) == null) continue;
                    throw new ModelException("The property \"" + declaredProp + "\" overrides property of super type, this is not allowed");
                }
            }
            this.props = Collections.unmodifiableMap(props);
        }
        return props;
    }

    @Override
    public ImmutableProp getProp(String name) {
        ImmutableProp prop = this.getProps().get(name);
        if (prop == null) {
            throw new IllegalArgumentException("There is no property \"" + name + "\" in \"" + this + "\"");
        }
        return prop;
    }

    @Override
    public Map<String, ImmutableProp> getSelectableProps() {
        Map<String, ImmutableProp> selectableProps = this.selectableProps;
        if (selectableProps == null) {
            selectableProps = new LinkedHashMap<String, ImmutableProp>();
            selectableProps.put(this.getIdProp().getName(), this.getIdProp());
            for (ImmutableProp prop : this.getProps().values()) {
                if (prop.isId() || !(prop.getStorage() instanceof Column)) continue;
                selectableProps.put(prop.getName(), prop);
            }
            this.selectableProps = Collections.unmodifiableMap(selectableProps);
        }
        return selectableProps;
    }

    void setIdProp(ImmutableProp idProp) {
        this.idProp = idProp;
        GeneratedValue generatedValue = idProp.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            return;
        }
        if (generatedValue.strategy() != GenerationType.USER && generatedValue.generatorType() != IdGenerator.None.class) {
            throw new ModelException("Illegal property \"" + idProp + "\", the generator cannot be specified when generation type is " + (Object)((Object)generatedValue.strategy()));
        }
        if (generatedValue.strategy() == GenerationType.USER) {
            Class<? extends IdGenerator> generatorType = generatedValue.generatorType();
            IdGenerator idGenerator = null;
            String error = null;
            Throwable errorCause = null;
            if (generatorType == IdGenerator.None.class) {
                error = "generator must be specified";
            }
            try {
                idGenerator = generatorType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException ex) {
                error = "cannot create the instance of \"" + generatorType.getName() + "\"";
                errorCause = ex;
            }
            catch (InvocationTargetException ex) {
                error = "cannot create the instance of \"" + generatorType.getName() + "\"";
                errorCause = ex.getTargetException();
            }
            if (error != null) {
                throw new ModelException("Illegal property \"" + idProp + "\" with the annotation @GeneratedValue, " + error, errorCause);
            }
            this.idGenerator = idGenerator;
        } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
            this.idGenerator = IdentityIdGenerator.INSTANCE;
        } else if (generatedValue.strategy() == GenerationType.SEQUENCE) {
            String sequenceName = generatedValue.sequenceName();
            if (sequenceName.isEmpty()) {
                sequenceName = this.tableName + "_ID_SEQ";
            }
            this.idGenerator = new SequenceIdGenerator(sequenceName);
        }
    }

    void setVersionProp(ImmutableProp versionProp) {
        this.versionProp = versionProp;
    }

    void setKeyProps(Set<ImmutableProp> keyProps) {
        this.keyProps = Collections.unmodifiableSet(keyProps);
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String toString() {
        return this.javaClass.getName();
    }

    public static class BuilderImpl
    implements ImmutableType.Builder {
        private ImmutableTypeImpl type;
        private String idPropName;
        private String versionPropName;
        private List<String> keyPropNames = new ArrayList<String>();

        BuilderImpl(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
            this.type = new ImmutableTypeImpl(javaClass, superType, draftFactory);
        }

        BuilderImpl(KClass<?> kotlinType, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
            this.type = new ImmutableTypeImpl(kotlinType, superType, draftFactory);
        }

        @Override
        public ImmutableType.Builder id(String name, Class<?> elementType) {
            if (!this.type.javaClass.isAnnotationPresent(Entity.class) && !this.type.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set id for type that is not entity");
            }
            if (this.idPropName != null) {
                throw new IllegalStateException("id property has been set");
            }
            this.idPropName = name;
            return this.add(name, ImmutablePropCategory.SCALAR, elementType, false);
        }

        @Override
        public ImmutableType.Builder key(String name, Class<?> elementType) {
            if (!this.type.javaClass.isAnnotationPresent(Entity.class) && !this.type.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot add key for type that is not entity");
            }
            this.keyPropNames.add(name);
            return this.add(name, ImmutablePropCategory.SCALAR, elementType, false);
        }

        @Override
        public ImmutableType.Builder keyReference(String name, Class<?> elementType, boolean nullable) {
            this.keyPropNames.add(name);
            return this.add(name, ImmutablePropCategory.REFERENCE, elementType, nullable, ManyToOne.class);
        }

        @Override
        public ImmutableType.Builder version(String name) {
            if (!this.type.javaClass.isAnnotationPresent(Entity.class) && !this.type.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set version for type that is not entity");
            }
            if (this.versionPropName != null) {
                throw new IllegalStateException("version property has been set");
            }
            this.versionPropName = name;
            return this.add(name, ImmutablePropCategory.SCALAR, Integer.TYPE, false);
        }

        @Override
        public ImmutableType.Builder add(String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable) {
            return this.add(name, category, elementType, nullable, null);
        }

        @Override
        public ImmutableType.Builder add(String name, Class<? extends Annotation> associationType, Class<?> elementType, boolean nullable) {
            ImmutablePropCategory category;
            if (associationType == OneToOne.class || associationType == ManyToOne.class) {
                category = ImmutablePropCategory.REFERENCE;
            } else if (associationType == OneToMany.class || associationType == ManyToMany.class) {
                category = ImmutablePropCategory.ENTITY_LIST;
            } else {
                throw new IllegalArgumentException("Invalid association type");
            }
            return this.add(name, category, elementType, nullable, associationType);
        }

        private ImmutableType.Builder add(String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable, Class<? extends Annotation> associationType) {
            this.validate();
            if (this.type.declaredProps.containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.type.javaClass.getName() + "." + name + "\" is already exists");
            }
            if (this.type.superType != null && this.type.getProps().containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.type.javaClass.getName() + "." + name + "\" is already exists in super type");
            }
            this.type.declaredProps.put(name, new ImmutablePropImpl(this.type, (this.type.superType != null ? this.type.superType.getProps().size() : 0) + this.type.declaredProps.size() + 1, name, category, elementType, nullable, associationType));
            return this;
        }

        @Override
        public ImmutableTypeImpl build() {
            this.validate();
            ImmutableTypeImpl type = this.type;
            type.declaredProps = Collections.unmodifiableMap(type.declaredProps);
            if (this.idPropName != null) {
                type.setIdProp((ImmutableProp)type.declaredProps.get(this.idPropName));
            } else if (type.superType != null) {
                type.setIdProp(type.superType.getIdProp());
            }
            if (this.versionPropName != null) {
                type.setVersionProp((ImmutableProp)type.declaredProps.get(this.versionPropName));
            } else if (type.superType != null) {
                type.setVersionProp(type.superType.getVersionProp());
            }
            LinkedHashSet<ImmutableProp> keyProps = type.superType != null ? new LinkedHashSet<ImmutableProp>(type.superType.getKeyProps()) : new LinkedHashSet();
            for (String keyPropName : this.keyPropNames) {
                keyProps.add((ImmutableProp)type.declaredProps.get(keyPropName));
            }
            type.setKeyProps(keyProps);
            this.type = null;
            return type;
        }

        private void validate() {
            if (this.type == null) {
                throw new IllegalStateException("Current ImmutableType.Builder has been disposed");
            }
        }
    }
}

