/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class ImmutableObjects {
    private static final ObjectMapper MAPPER;

    private ImmutableObjects() {
    }

    public static boolean isLoaded(Object immutable, int prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__isLoaded(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static boolean isLoaded(Object immutable, String prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__isLoaded(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static Object get(Object immutable, int prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__get(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static Object get(Object immutable, String prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__get(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static String toString(Object immutable) {
        try {
            return MAPPER.writeValueAsString(immutable);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <I> I fromString(Class<I> type, String json) throws JsonProcessingException {
        return (I)MAPPER.readValue(json, type);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new ImmutableModule());
        MAPPER = mapper;
    }
}

