/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.impl.Utils;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.Storage;

public class Storages {
    static Storage of(ImmutableProp prop) {
        Annotation annotation = prop.getAssociationAnnotation();
        if (annotation instanceof OneToOne || annotation instanceof OneToMany || annotation instanceof ManyToMany && !((ManyToMany)annotation).mappedBy().isEmpty()) {
            return null;
        }
        if (annotation == null) {
            String columnName;
            ImmutableProp idProp = prop.getDeclaringType().getIdProp();
            Column column = prop.getName().equals(idProp.getName()) ? idProp.getAnnotation(Column.class) : prop.getAnnotation(Column.class);
            String string = columnName = column != null ? column.name() : "";
            if (columnName.isEmpty()) {
                columnName = Utils.databaseIdentifier(prop.getName());
            }
            return new org.babyfish.jimmer.sql.meta.Column(columnName);
        }
        Storage storage = Storages.middleTable(prop, false);
        if (storage == null) {
            storage = Storages.joinColumn(prop, false);
        }
        if (storage == null) {
            storage = prop.getAssociationAnnotation() instanceof ManyToMany ? Storages.middleTable(prop, true) : Storages.joinColumn(prop, true);
        }
        return storage;
    }

    private static MiddleTable middleTable(ImmutableProp prop, boolean force) {
        String targetJoinColumn;
        String joinColumnName;
        String tableName;
        JoinTable joinTable = prop.getAnnotation(JoinTable.class);
        if (joinTable == null && !force) {
            return null;
        }
        String string = tableName = joinTable != null ? joinTable.name() : "";
        if (tableName.isEmpty()) {
            tableName = Utils.databaseIdentifier(prop.getDeclaringType().getJavaClass().getSimpleName()) + '_' + Utils.databaseIdentifier(prop.getElementClass().getSimpleName()) + "_MAPPING";
        }
        String string2 = joinColumnName = joinTable != null && joinTable.joinColumns().length != 0 ? joinTable.joinColumns()[0].name() : "";
        if (joinColumnName.isEmpty()) {
            joinColumnName = ((org.babyfish.jimmer.sql.meta.Column)prop.getDeclaringType().getIdProp().getStorage()).getName();
        }
        String string3 = targetJoinColumn = joinTable != null && joinTable.inverseJoinColumns().length != 0 ? joinTable.inverseJoinColumns()[0].name() : "";
        if (targetJoinColumn.isEmpty()) {
            targetJoinColumn = Utils.databaseIdentifier(prop.getName()) + "_ID";
        }
        if (joinColumnName.equals(targetJoinColumn)) {
            throw new ModelException("Illegal property \"" + prop + "\", please specify join columns and inverse join columns explicitly because they cannot be decided automatically");
        }
        return new MiddleTable(tableName, joinColumnName, targetJoinColumn);
    }

    private static org.babyfish.jimmer.sql.meta.Column joinColumn(ImmutableProp prop, boolean force) {
        String columnName;
        JoinColumn joinColumn = prop.getAnnotation(JoinColumn.class);
        if (joinColumn == null && !force) {
            return null;
        }
        String string = columnName = joinColumn != null ? joinColumn.name() : "";
        if (columnName.isEmpty()) {
            columnName = Utils.databaseIdentifier(prop.getName()) + "_ID";
        }
        return new org.babyfish.jimmer.sql.meta.Column(columnName);
    }
}

