/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.impl.ImmutableTypeImpl;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.meta.impl.Storages;
import org.babyfish.jimmer.sql.DeleteAction;
import org.babyfish.jimmer.sql.OnDelete;
import org.babyfish.jimmer.sql.meta.Storage;

class ImmutablePropImpl
implements ImmutableProp {
    private ImmutableTypeImpl declaringType;
    private String name;
    private ImmutablePropCategory category;
    private Class<?> elementClass;
    private boolean nullable;
    private Method getter;
    private Annotation associationAnnotation;
    private boolean isTransient;
    private DeleteAction deleteAction;
    private Storage storage;
    private boolean storageResolved;
    private ImmutableTypeImpl targetType;
    private boolean targetTypeResolved;
    private ImmutableProp mappedBy;
    private boolean mappedByResolved;
    private ImmutableProp opposite;
    private boolean oppositeResolved;

    ImmutablePropImpl(ImmutableTypeImpl declaringType, String name, ImmutablePropCategory category, Class<?> elementClass, boolean nullable, Class<? extends Annotation> associationType) {
        OnDelete onDelete;
        this.declaringType = declaringType;
        this.name = name;
        this.category = category;
        this.elementClass = elementClass;
        this.nullable = nullable;
        try {
            this.getter = declaringType.getJavaClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.getter = declaringType.getJavaClass().getDeclaredMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.getter = declaringType.getJavaClass().getDeclaredMethod("is" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (this.getter == null) {
            throw new AssertionError((Object)("Internal bug: Cannot find the getter of prop \"" + name + "\" of the interface \"" + declaringType.getJavaClass().getName() + "\""));
        }
        boolean bl = this.isTransient = this.getAnnotation(Transient.class) != null;
        if (associationType != null) {
            this.associationAnnotation = this.getAnnotation(associationType);
        }
        this.deleteAction = (onDelete = this.getAnnotation(OnDelete.class)) != null ? onDelete.value() : DeleteAction.NONE;
    }

    @Override
    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutablePropCategory getCategory() {
        return this.category;
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public boolean isScalar() {
        return this.category == ImmutablePropCategory.SCALAR;
    }

    @Override
    public boolean isScalarList() {
        return this.category == ImmutablePropCategory.SCALAR_LIST;
    }

    @Override
    public boolean isAssociation() {
        return this.category.isAssociation();
    }

    @Override
    public boolean isReference() {
        return this.category == ImmutablePropCategory.REFERENCE;
    }

    @Override
    public boolean isEntityList() {
        return this.category == ImmutablePropCategory.ENTITY_LIST;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.getter.getAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        return this.getter.getAnnotationsByType(annotationType);
    }

    @Override
    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    @Override
    public <S extends Storage> S getStorage() {
        if (this.storageResolved) {
            return (S)this.storage;
        }
        this.storage = Storages.of(this);
        this.storageResolved = true;
        return (S)this.storage;
    }

    @Override
    public boolean isId() {
        return this == this.declaringType.getIdProp();
    }

    @Override
    public boolean isVersion() {
        return this == this.declaringType.getVersionProp();
    }

    @Override
    public ImmutableType getTargetType() {
        if (this.targetTypeResolved) {
            return this.targetType;
        }
        if (this.isAssociation()) {
            this.targetType = Metadata.tryGet(this.elementClass);
            if (this.targetType == null) {
                throw new ModelException("Cannot resolve target type of \"" + this + "\"");
            }
        }
        this.targetTypeResolved = true;
        return this.targetType;
    }

    @Override
    public ImmutableProp getMappedBy() {
        if (this.mappedByResolved) {
            return this.mappedBy;
        }
        if (this.isAssociation()) {
            String mappedBy = "";
            OneToOne oneToOne = this.getAnnotation(OneToOne.class);
            if (oneToOne != null) {
                mappedBy = oneToOne.mappedBy();
            }
            if (mappedBy.isEmpty()) {
                ManyToMany manyToMany;
                OneToMany oneToMany = this.getAnnotation(OneToMany.class);
                if (oneToMany != null) {
                    mappedBy = oneToMany.mappedBy();
                }
                if (mappedBy.isEmpty() && (manyToMany = this.getAnnotation(ManyToMany.class)) != null) {
                    mappedBy = manyToMany.mappedBy();
                }
            }
            if (!mappedBy.isEmpty()) {
                ImmutableProp resolved = this.getTargetType().getProps().get(mappedBy);
                if (resolved == null) {
                    throw new ModelException("Cannot resolve the mappedBy property name \"" + mappedBy + "\" for property \"" + this + "\"");
                }
                if (resolved.isReference() && this.associationAnnotation.annotationType() != OneToOne.class && this.associationAnnotation.annotationType() != OneToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one of one-to-many property because its mappedBy property \"" + resolved + "\" is reference");
                }
                if (resolved.isEntityList() && this.associationAnnotation.annotationType() != ManyToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be many-to-many property because its mappedBy property \"" + resolved + "\" is list");
                }
                this.mappedBy = resolved;
            }
        }
        this.mappedByResolved = true;
        return this.mappedBy;
    }

    @Override
    public ImmutableProp getOpposite() {
        if (this.oppositeResolved) {
            return this.opposite;
        }
        if (this.isAssociation()) {
            this.opposite = this.getMappedBy();
            if (this.opposite == null) {
                for (ImmutableProp backProp : this.getTargetType().getProps().values()) {
                    if (backProp.getMappedBy() != this) continue;
                    this.opposite = backProp;
                    break;
                }
            }
        }
        this.oppositeResolved = true;
        return this.opposite;
    }

    public String toString() {
        return this.declaringType.toString() + '.' + this.name;
    }
}

