/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.ListDraft;

public class DraftContext {
    private static Class<?> EMPTY_LIST_CLASS = Collections.emptyList().getClass();
    private static Class<?> UNMODIFIED_LIST_CLASS = Collections.unmodifiableList(new ArrayList()).getClass();
    private final IdentityHashMap<Object, Draft> objDraftMap = new IdentityHashMap();
    private final IdentityHashMap<List<?>, ListDraft<?>> listDraftMap = new IdentityHashMap();

    public <D> D toDraftObject(Object obj) {
        if (obj == null || obj instanceof Draft) {
            return (D)obj;
        }
        Draft draft = this.objDraftMap.get(obj);
        if (draft == null) {
            if (obj instanceof List) {
                throw new IllegalArgumentException("DraftContext.toDraftObject dose not accept list");
            }
            draft = ((ImmutableSpi)obj).__type().getDraftFactory().apply(this, obj);
            this.objDraftMap.put(obj, draft);
        }
        return (D)draft;
    }

    public <E, D> List<D> toDraftList(List<E> list, Class<E> elementType, boolean isElementImmutable) {
        if (list == null || list instanceof Draft) {
            return list;
        }
        ListDraft<Object> draft = this.listDraftMap.get(list);
        if (draft == null) {
            draft = isElementImmutable ? new ListDraft<E>(this, elementType, list) : new ListDraft<E>(elementType, list);
            this.listDraftMap.put(list, draft);
        }
        return draft;
    }

    public <E> E resolveObject(E obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            throw new IllegalArgumentException("DraftContext.resolveObject dose not accept list");
        }
        Draft draft = obj instanceof Draft ? (Draft)obj : this.objDraftMap.get(obj);
        if (draft == null) {
            return obj;
        }
        DraftSpi spi = (DraftSpi)draft;
        if (spi.__draftContext() != this) {
            throw new IllegalArgumentException("Cannot resolve the draft object because it belong to another draft context");
        }
        return (E)spi.__resolve();
    }

    public <E> List<E> resolveList(List<E> list) {
        if (list == null) {
            return null;
        }
        List<E> resolvedList = this.resolveListImpl(list);
        if (EMPTY_LIST_CLASS.isAssignableFrom(resolvedList.getClass()) || UNMODIFIED_LIST_CLASS.isAssignableFrom(resolvedList.getClass())) {
            return resolvedList;
        }
        return Collections.unmodifiableList(resolvedList);
    }

    private <E> List<E> resolveListImpl(List<E> list) {
        ListDraft<?> draft = list instanceof Draft ? (ListDraft<?>)list : this.listDraftMap.get(list);
        if (draft == null) {
            List<E> newList = null;
            int index = 0;
            for (E e : list) {
                E resolved = this.resolveObject(e);
                if (resolved != e && newList == null) {
                    newList = new ArrayList<E>(list.subList(0, index));
                }
                if (newList != null) {
                    newList.add(resolved);
                }
                ++index;
            }
            return newList != null ? newList : list;
        }
        if (draft.draftContext() != null && draft.draftContext() != this) {
            throw new IllegalArgumentException("Cannot resolve the draft list because it belong to another draft context");
        }
        return draft.resolve();
    }
}

