/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.babyfish.jimmer.jackson.Utils;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;

public class ImmutableDeserializer
extends StdDeserializer<Object> {
    private ImmutableType immutableType;

    public ImmutableDeserializer(ImmutableType immutableType) {
        super(immutableType.getJavaClass());
        this.immutableType = immutableType;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        Class rawClass = this.handledType();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return Internal.produce(this.immutableType, null, draft -> {
            for (ImmutableProp prop : this.immutableType.getProps().values()) {
                if (!node.has(prop.getName())) continue;
                Object value = ctx.readTreeAsValue(node.get(prop.getName()), Utils.getJacksonType(prop));
                ((DraftSpi)draft).__set(prop.getName(), value);
            }
        });
    }
}

