/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.meata.ImmutableProp;
import org.babyfish.jimmer.meata.ImmutablePropCategory;
import org.babyfish.jimmer.runtime.DraftContext;

public class ImmutableType {
    private static Map<Class<?>, ImmutableType> positiveCacheMap = new WeakHashMap();
    private static Map<Class<?>, Void> negativeCacheMap = new LRUMap();
    private static ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private Class<?> javaClass;
    private ImmutableType superType;
    private BiFunction<DraftContext, Object, Draft> draftFactory;
    Map<String, ImmutableProp> declaredProps = new LinkedHashMap<String, ImmutableProp>();
    Map<String, ImmutableProp> props;

    ImmutableType(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        this.javaClass = javaClass;
        this.superType = superType;
        this.draftFactory = draftFactory;
    }

    public static Builder newBuilder(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        return new Builder(javaClass, superType, draftFactory);
    }

    private static Class<?> getImmutableJavaClass(Class<?> javaClass) {
        Class<?> immutableJavaClass;
        boolean matched = Arrays.stream(javaClass.getAnnotations()).anyMatch(it -> it.annotationType() == Immutable.class || it.annotationType().getName().equals("javax.persistence.Entity"));
        if (matched) {
            return javaClass;
        }
        Class<?> superClass = javaClass.getSuperclass();
        if (superClass != null && superClass != Object.class && (immutableJavaClass = ImmutableType.getImmutableJavaClass(superClass)) != null) {
            return immutableJavaClass;
        }
        for (Class<?> interfaceClass : javaClass.getInterfaces()) {
            Class<?> immutableJavaClass2 = ImmutableType.getImmutableJavaClass(interfaceClass);
            if (immutableJavaClass2 == null) continue;
            return immutableJavaClass2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableType tryGet(Class<?> javaClass) {
        ImmutableType immutableType;
        Lock lock = cacheLock.readLock();
        lock.lock();
        try {
            if (negativeCacheMap.containsKey(javaClass)) {
                ImmutableType immutableType2 = null;
                return immutableType2;
            }
            immutableType = positiveCacheMap.get(javaClass);
        }
        finally {
            lock.unlock();
        }
        if (immutableType == null) {
            lock = cacheLock.writeLock();
            lock.lock();
            try {
                if (negativeCacheMap.containsKey(javaClass)) {
                    ImmutableType immutableType3 = null;
                    return immutableType3;
                }
                immutableType = positiveCacheMap.get(javaClass);
                if (immutableType == null) {
                    immutableType = ImmutableType.create(javaClass);
                    if (immutableType != null) {
                        positiveCacheMap.put(javaClass, immutableType);
                    } else {
                        negativeCacheMap.put(javaClass, null);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return immutableType;
    }

    private static ImmutableType create(Class<?> javaClass) {
        Field typeField;
        Class<?> draftClass;
        Class<?> immutableJavaClass = ImmutableType.getImmutableJavaClass(javaClass);
        if (immutableJavaClass == null) {
            return null;
        }
        try {
            draftClass = Class.forName(immutableJavaClass.getName() + "Draft");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot find draft type for \"" + immutableJavaClass.getName() + "\"");
        }
        Class producerClass = Arrays.stream(draftClass.getDeclaredClasses()).filter(it -> it.getSimpleName().equals("Producer")).findFirst().orElse(null);
        if (producerClass == null) {
            throw new IllegalArgumentException("Cannot find producer type for \"" + draftClass.getName() + "\"");
        }
        try {
            typeField = producerClass.getField("TYPE");
        }
        catch (NoSuchFieldException ex) {
            typeField = null;
        }
        if (!(typeField != null && Modifier.isPublic(typeField.getModifiers()) && Modifier.isStatic(typeField.getModifiers()) && Modifier.isFinal(typeField.getModifiers()) && typeField.getType() == ImmutableType.class)) {
            throw new IllegalArgumentException("Illegal producer type \"" + producerClass.getName() + "\"");
        }
        try {
            return (ImmutableType)typeField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Internal bug: Cannot access " + typeField));
        }
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public ImmutableType getSuperType() {
        return this.superType;
    }

    public BiFunction<DraftContext, Object, Draft> getDraftFactory() {
        return this.draftFactory;
    }

    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    public Map<String, ImmutableProp> getProps() {
        Map<String, ImmutableProp> props = this.props;
        if (props == null) {
            if (this.superType == null) {
                props = this.declaredProps;
            } else {
                props = new LinkedHashMap<String, ImmutableProp>(this.superType.getProps());
                props.putAll(this.declaredProps);
            }
            this.props = props;
        }
        return props;
    }

    public String toString() {
        return this.javaClass.getName();
    }

    public static class Builder {
        private ImmutableType type;

        Builder(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
            this.type = new ImmutableType(javaClass, superType, draftFactory);
        }

        public Builder add(String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable) {
            this.validate();
            if (this.type.declaredProps.containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.type.javaClass.getName() + "." + name + "\" is already exists");
            }
            this.type.declaredProps.put(name, new ImmutableProp(this.type, name, category, elementType, nullable));
            return this;
        }

        public ImmutableType build() {
            this.validate();
            ImmutableType type = this.type;
            type.declaredProps = Collections.unmodifiableMap(type.declaredProps);
            this.type = null;
            return type;
        }

        private void validate() {
            if (this.type == null) {
                throw new IllegalStateException("Current ImmutableType.Builder has been disposed");
            }
        }
    }

    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        LRUMap() {
            super(200, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return true;
        }
    }
}

