/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.runtime;

import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.DraftConsumer;
import org.babyfish.jimmer.DraftConsumerException;
import org.babyfish.jimmer.meata.ImmutableType;
import org.babyfish.jimmer.runtime.DraftContext;

public class Internal {
    private static final ThreadLocal<DraftContext> DRAFT_CONTEXT_LOCAL = new ThreadLocal();

    private Internal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object produce(ImmutableType type, Object base, DraftConsumer<? extends Draft> block) {
        DraftContext ctx = DRAFT_CONTEXT_LOCAL.get();
        if (ctx != null) {
            Draft draft = type.getDraftFactory().apply(ctx, base);
            if (block != null) {
                try {
                    block.accept(draft);
                }
                catch (Throwable ex) {
                    throw new DraftConsumerException(ex);
                }
            }
            return draft;
        }
        ctx = new DraftContext();
        DRAFT_CONTEXT_LOCAL.set(ctx);
        try {
            Draft draft = type.getDraftFactory().apply(ctx, base);
            if (block != null) {
                try {
                    block.accept(draft);
                }
                catch (Throwable ex) {
                    throw new DraftConsumerException(ex);
                }
            }
            Draft draft2 = ctx.resolveObject(draft);
            return draft2;
        }
        finally {
            DRAFT_CONTEXT_LOCAL.remove();
        }
    }
}

