/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.openapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Description {
    private static final Description NIL = new Description(null, Collections.emptyList());
    private final String summary;
    private final List<String> descriptionLines;

    public Description(String summary, List<String> descriptionLines) {
        this.summary = summary;
        this.descriptionLines = descriptionLines;
    }

    @Nullable
    public String getSummary() {
        return this.summary;
    }

    @NotNull
    public List<String> getDescriptionLines() {
        return this.descriptionLines;
    }

    public static Description of(String doc) {
        return Description.of(doc, false);
    }

    public static Description of(String doc, boolean extractSummary) {
        if (doc == null || doc.isEmpty()) {
            return NIL;
        }
        boolean summaryExtracted = !extractSummary;
        String summary = null;
        ArrayList<String> descriptionLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(doc));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                boolean notBlank = false;
                int len = line.length();
                for (int i = 0; i < len; ++i) {
                    if (line.charAt(i) <= ' ') continue;
                    notBlank = true;
                    break;
                }
                if (!notBlank) continue;
                if (summaryExtracted) {
                    descriptionLines.add(line);
                    continue;
                }
                summary = line;
                summaryExtracted = true;
            }
        }
        catch (IOException ex) {
            throw new AssertionError("Internal bug: Cannot read data from string reader", ex);
        }
        return new Description(summary, Collections.unmodifiableList(descriptionLines));
    }
}

