/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.client.source.SourceManager;

public abstract class SourceWriter
extends CodeWriter<SourceWriter> {
    private final Context ctx;
    protected final Source source;
    private final SourceManager sourceManager;

    public SourceWriter(Context ctx, Source source) {
        super(ctx.getIndent());
        this.ctx = ctx;
        this.source = source;
        this.sourceManager = ctx.sourceManager;
    }

    public final <C extends Context> C getContext() {
        return (C)this.ctx;
    }

    public abstract SourceWriter typeRef(Type var1);

    protected final Source getSource(Type type) {
        ObjectType objectType;
        ObjectType unwrapped;
        Source importedSource = type instanceof ObjectType ? ((unwrapped = (objectType = (ObjectType)type).unwrap()) != null ? this.sourceManager.getSource(unwrapped) : this.sourceManager.getSource(objectType)) : this.sourceManager.getSource(type);
        if (importedSource != null && importedSource.getRoot() != this.source.getRoot()) {
            this.importSource(importedSource.getRoot());
        }
        return importedSource;
    }

    public final void importSource(Source source) {
        this.importSource(source, source.getName(), false);
    }

    public final void importSource(Source source, String name) {
        this.importSource(source, name, false);
    }

    public final void importSource(Source source, boolean treatAsValue) {
        this.importSource(source, source.getName(), treatAsValue);
    }

    public abstract void importSource(Source var1, String var2, boolean var3);

    protected abstract void onFlushImportedTypes();

    public SourceWriter doc(Doc doc, DocPart ... parts) {
        if (doc == null) {
            return this;
        }
        EnumSet<DocPart> partSet = EnumSet.noneOf(DocPart.class);
        partSet.addAll(Arrays.asList(parts));
        if (partSet.isEmpty() && doc.getValue() == null) {
            return this;
        }
        this.code("/**\n");
        if (doc.getValue() != null) {
            ((SourceWriter)((SourceWriter)this.code(" * ")).code(doc.getValue().replace("\n", "\n * "))).code('\n');
        }
        if (partSet.contains((Object)DocPart.PARAM)) {
            for (Map.Entry e : doc.getParameterValueMap().entrySet()) {
                ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)this.code(" * @param ")).code((String)e.getKey())).code(' ')).code(((String)e.getValue()).replace("\n", "\n * "))).code('\n');
            }
        }
        if (partSet.contains((Object)DocPart.RETURN) && doc.getReturnValue() != null) {
            ((SourceWriter)((SourceWriter)this.code(" * @return ")).code(doc.getReturnValue().replace("\n", "\n * "))).code('\n');
        }
        if (partSet.contains((Object)DocPart.PROPERTY)) {
            for (Map.Entry e : doc.getParameterValueMap().entrySet()) {
                ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)this.code("@property ")).code((String)e.getKey())).code(' ')).code(((String)e.getValue()).replace("\n", "\n * "))).code('\n');
            }
        }
        this.code(" */\n");
        return this;
    }

    public SourceWriter doc(String text) {
        if (text == null || text.isEmpty()) {
            return this;
        }
        this.code("/**\n");
        ((SourceWriter)((SourceWriter)this.code(" * ")).code(text.replace("\n", "\n * "))).code('\n');
        this.code(" */\n");
        return this;
    }

    public SourceWriter renderChildren() {
        for (Source subSource : this.source.getSubSources()) {
            subSource.getRender().render(this);
        }
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    public static enum DocPart {
        PARAM,
        RETURN,
        PROPERTY;

    }

    private static class Scope {
        private final Scope parent;
        final String separator;
        final boolean multiLines;
        boolean dirty;

        Scope(Scope parent, String separator, boolean multiLines) {
            this.parent = parent;
            this.separator = separator;
            this.multiLines = multiLines;
        }

        void dirty() {
            if (!this.dirty) {
                this.dirty = true;
                if (this.parent != null) {
                    this.parent.dirty();
                }
            }
        }
    }
}

