/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.impl.util.StringUtil;

public class ApiErrorsRender
implements Render {
    private final String name;
    private final List<Service> services;
    private final Set<ObjectType> usedExceptionTypes;

    public ApiErrorsRender(String name, List<Service> services) {
        this.name = name;
        this.services = services;
        LinkedHashSet<ObjectType> exceptionTypes = new LinkedHashSet<ObjectType>();
        for (Service service : services) {
            for (Operation operation : service.getOperations()) {
                exceptionTypes.addAll(operation.getExceptionTypes());
            }
        }
        this.usedExceptionTypes = exceptionTypes;
    }

    @Override
    public void export(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export type {AllErrors, ")).code(this.name)).code("} from './")).code(this.name)).code("';\n");
    }

    @Override
    public void render(SourceWriter writer) {
        this.renderAllErrors(writer);
        this.renderApiErrors(writer);
    }

    private void renderAllErrors(SourceWriter writer) {
        writer.code("export type AllErrors = ");
        if (this.usedExceptionTypes.isEmpty()) {
            writer.code("{};\n");
            return;
        }
        writer.scope(CodeWriter.ScopeType.BLANK, " | ", false, () -> {
            for (ObjectType exceptionType : this.usedExceptionTypes) {
                TypeDefinition.Error error = exceptionType.getError();
                assert (error != null);
                writer.separator();
                writer.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                    ((SourceWriter)((SourceWriter)writer.code("family: '")).code(error.getFamily())).code('\'');
                    writer.separator();
                    ((SourceWriter)((SourceWriter)writer.code("code: '")).code(error.getCode())).code('\'');
                    for (Property property : exceptionType.getProperties().values()) {
                        writer.separator();
                        ((SourceWriter)((SourceWriter)((SourceWriter)writer.doc(property.getDoc(), new SourceWriter.DocPart[0]).code(property.getName())).codeIf(property.getType() instanceof NullableType, '?')).code(": ")).typeRef(property.getType());
                    }
                });
            }
        });
        writer.code(";\n");
    }

    private void renderApiErrors(SourceWriter writer) {
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        ((SourceWriter)((SourceWriter)writer.code("export type ")).code(this.name)).code(" = ");
        if (this.usedExceptionTypes.isEmpty()) {
            writer.code("{};\n");
            return;
        }
        writer.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
            for (Service service : this.services) {
                Source serviceSource = ctx.getSource(service);
                writer.separator();
                ((SourceWriter)((SourceWriter)writer.code("'")).code(StringUtil.identifier((String[])new String[]{serviceSource.getName()}))).code("': ");
                writer.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                    for (Operation operation : service.getOperations()) {
                        if (operation.getExceptionTypes().isEmpty()) continue;
                        writer.separator();
                        Source operationSource = ctx.getSource(operation);
                        ((SourceWriter)((SourceWriter)writer.code('\'')).code(operationSource.getName())).code("': AllErrors & ");
                        writer.scope(CodeWriter.ScopeType.ARGUMENTS, " | ", false, () -> {
                            for (ObjectType exceptionType : operation.getExceptionTypes()) {
                                TypeDefinition.Error error = exceptionType.getError();
                                assert (error != null);
                                writer.separator();
                                writer.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
                                    ((SourceWriter)((SourceWriter)writer.code("family: '")).code(error.getFamily())).code('\'');
                                    writer.separator();
                                    ((SourceWriter)((SourceWriter)writer.code("code: '")).code(error.getCode())).code('\'');
                                    writer.separator();
                                    writer.code("readonly [key:string]: any");
                                });
                            }
                        });
                    }
                });
            }
        });
        writer.code(";\n");
    }
}

