/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.runtime.FetchByInfo;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.TypeResolvingException;
import org.babyfish.jimmer.client.runtime.impl.Graph;
import org.babyfish.jimmer.client.runtime.impl.PropertyImpl;
import org.babyfish.jimmer.client.runtime.impl.TypeContext;
import org.babyfish.jimmer.client.runtime.impl.TypeVariableImpl;
import org.babyfish.jimmer.meta.ImmutableType;
import org.jetbrains.annotations.Nullable;

public class StaticObjectTypeImpl
extends Graph
implements ObjectType {
    private final Class<?> javaType;
    private final List<String> simpleNames;
    private List<Type> arguments;
    @Nullable
    private Doc doc;
    @Nullable
    private TypeDefinition.Error error;
    private Map<String, Property> properties;

    public StaticObjectTypeImpl(Class<?> javaType) {
        this.javaType = javaType;
        ArrayList<String> simpleNames = new ArrayList<String>();
        for (Class<?> type = javaType; type != null; type = type.getDeclaringClass()) {
            simpleNames.add(0, type.getSimpleName());
        }
        this.simpleNames = Collections.unmodifiableList(simpleNames);
    }

    void init(TypeName typeName, List<Type> arguments, TypeContext ctx) {
        try {
            TypeDefinition definition = ctx.definition(typeName);
            if (arguments.isEmpty() && this.javaType.getTypeParameters().length != 0) {
                arguments = Arrays.stream(this.javaType.getTypeParameters()).map(it -> new TypeVariableImpl(typeName.typeVariable(it.getName()))).collect(Collectors.toList());
            }
            this.arguments = arguments;
            LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
            this.collectProperties(definition, ctx, properties);
            this.doc = definition.getDoc();
            this.error = definition.getError();
            this.properties = Collections.unmodifiableMap(properties);
        }
        catch (TypeResolvingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new TypeResolvingException(typeName, ex);
        }
    }

    private void collectProperties(TypeDefinition definition, TypeContext ctx, Map<String, Property> properties) {
        for (Prop prop : definition.getPropMap().values()) {
            if (properties.containsKey(prop.getName())) continue;
            try {
                properties.put(prop.getName(), new PropertyImpl(prop.getName(), ctx.parseType(prop.getType()), prop.getDoc()));
            }
            catch (TypeResolvingException ex) {
                throw new TypeResolvingException(definition.getTypeName(), '@' + prop.getName(), ex);
            }
        }
        for (TypeRef superTypeRef : definition.getSuperTypes()) {
            try {
                List<Type> arguments;
                TypeDefinition superDefinition = ctx.definition(superTypeRef.getTypeName());
                if (superDefinition == null || superDefinition.getPropMap().isEmpty()) continue;
                if (superTypeRef.getArguments().isEmpty()) {
                    arguments = Collections.emptyList();
                } else {
                    arguments = new ArrayList(superTypeRef.getArguments().size());
                    for (TypeRef arg : superTypeRef.getArguments()) {
                        arguments.add(ctx.parseType(arg));
                    }
                }
                ctx.generic(ctx.javaType(superDefinition.getTypeName()), arguments, () -> {
                    for (Prop superProp : superDefinition.getPropMap().values()) {
                        if (properties.containsKey(superProp.getName())) continue;
                        properties.put(superProp.getName(), new PropertyImpl(superProp.getName(), ctx.parseType(superProp.getType()), superProp.getDoc()));
                    }
                });
            }
            catch (TypeResolvingException ex) {
                throw new TypeResolvingException(definition.getTypeName(), ":super", ex);
            }
        }
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    @Nullable
    public ImmutableType getImmutableType() {
        return null;
    }

    @Override
    public ObjectType.Kind getKind() {
        return this.error != null ? ObjectType.Kind.ERROR : ObjectType.Kind.STATIC;
    }

    @Override
    public List<String> getSimpleNames() {
        return this.simpleNames;
    }

    @Override
    @Nullable
    public FetchByInfo getFetchByInfo() {
        return null;
    }

    @Override
    public List<Type> getArguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    @Override
    @Nullable
    public TypeDefinition.Error getError() {
        return this.error;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isRecursiveFetchedType() {
        return false;
    }

    @Override
    public ObjectType unwrap() {
        return null;
    }

    @Override
    protected String toStringImpl(Set<Graph> stack) {
        if (this.arguments.isEmpty()) {
            return this.javaType.getName() + '{' + this.properties.values().stream().map(it -> StaticObjectTypeImpl.string(it, stack)).collect(Collectors.joining(", ")) + '}';
        }
        return this.javaType.getName() + '<' + this.arguments.stream().map(it -> StaticObjectTypeImpl.string(it, stack)).collect(Collectors.joining(", ")) + "> {" + this.properties.values().stream().map(it -> StaticObjectTypeImpl.string(it, stack)).collect(Collectors.joining(", ")) + '}';
    }
}

