/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.Metadata;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.impl.IllegalApiException;

public class MetadataImpl
implements Metadata {
    private final boolean isGenericSupported;
    private final Map<String, List<Operation>> pathMap;
    private final List<Service> services;
    private final List<ObjectType> fetchedTypes;
    private final List<ObjectType> dynamicTypes;
    private final List<ObjectType> staticTypes;
    private final List<EnumType> enumTypes;
    private final Map<Class<?>, Type> typeMap;

    public MetadataImpl(boolean isGenericSupported, List<Service> services, List<ObjectType> fetchedTypes, List<ObjectType> dynamicTypes, List<ObjectType> staticTypes, List<EnumType> enumTypes) {
        this.isGenericSupported = isGenericSupported;
        this.pathMap = MetadataImpl.getPathMap(services);
        this.services = services;
        this.fetchedTypes = fetchedTypes;
        this.dynamicTypes = dynamicTypes;
        this.staticTypes = staticTypes;
        this.enumTypes = enumTypes;
        HashMap typeMap = new HashMap();
        for (ObjectType fetchedType : fetchedTypes) {
            typeMap.put(fetchedType.getJavaType(), fetchedType);
        }
        for (ObjectType dynamicType : dynamicTypes) {
            typeMap.put(dynamicType.getJavaType(), dynamicType);
        }
        for (ObjectType staticType : staticTypes) {
            typeMap.put(staticType.getJavaType(), staticType);
        }
        for (EnumType enumType : enumTypes) {
            typeMap.put(enumType.getJavaType(), enumType);
        }
        this.typeMap = typeMap;
    }

    private static Map<String, List<Operation>> getPathMap(List<Service> services) {
        TreeMap<String, Map> map = new TreeMap<String, Map>();
        for (Service service : services) {
            for (Operation operation : service.getOperations()) {
                Map subMap = map.computeIfAbsent(operation.getUri(), it -> new TreeMap());
                for (Operation.HttpMethod method : operation.getHttpMethods()) {
                    Operation conflictOperation = subMap.put(method, operation);
                    if (conflictOperation == null) continue;
                    throw new IllegalApiException("Conflict HTTP endpoint \"" + (Object)((Object)method) + ":" + operation.getUri() + "\" which is shared by \"" + conflictOperation.getJavaMethod() + "\" and \"" + operation.getJavaMethod() + "\"");
                }
            }
        }
        TreeMap pathMap = new TreeMap();
        for (Map.Entry e : map.entrySet()) {
            pathMap.put((String)e.getKey(), Collections.unmodifiableList(new ArrayList(((Map)e.getValue()).values())));
        }
        return Collections.unmodifiableMap(pathMap);
    }

    @Override
    public boolean isGenericSupported() {
        return this.isGenericSupported;
    }

    @Override
    public Map<String, List<Operation>> getPathMap() {
        return this.pathMap;
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public List<ObjectType> getFetchedTypes() {
        return this.fetchedTypes;
    }

    @Override
    public List<ObjectType> getDynamicTypes() {
        return this.dynamicTypes;
    }

    @Override
    public List<ObjectType> getStaticTypes() {
        return this.staticTypes;
    }

    @Override
    public List<EnumType> getEnumTypes() {
        return this.enumTypes;
    }

    @Override
    public Type getType(Class<?> type) {
        return this.typeMap.get(type);
    }

    public String toString() {
        return "MetadataImpl{services=" + this.services + ", fetchedTypes=" + this.fetchedTypes + ", dynamicTypes=" + this.dynamicTypes + ", staticTypes=" + this.staticTypes + ", enumTypes=" + this.enumTypes + '}';
    }
}

