/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Parameter;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.impl.NullableTypeImpl;

public class ServiceRender
implements Render {
    private final String name;
    private final Service service;

    public ServiceRender(String name, Service service) {
        this.name = name;
        this.service = service;
    }

    @Override
    public void export(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export {")).code(this.name)).code("} from './")).code(this.name)).code("';\n");
    }

    @Override
    public void render(SourceWriter writer) {
        this.renderService(writer);
        this.renderOptions(writer);
    }

    private void renderService(SourceWriter writer) {
        writer.importSource(((Context)writer.getContext()).getRootSource("Executor"));
        ((SourceWriter)((SourceWriter)writer.doc(this.service.getDoc(), new SourceWriter.DocPart[0]).code("export class ")).code(this.name)).code(' ');
        writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            writer.code("\nconstructor(private executor: Executor) {}\n");
            writer.renderChildren();
        });
        writer.code('\n');
    }

    private void renderOptions(SourceWriter writer) {
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        ((SourceWriter)((SourceWriter)writer.code("export type ")).code(this.name)).code("Options = ");
        writer.scope(CodeWriter.ScopeType.OBJECT, ", ", true, () -> {
            for (Operation operation : this.service.getOperations()) {
                ((SourceWriter)((SourceWriter)((SourceWriter)writer.separator()).code('\'')).code(ctx.getSource(operation).getName())).code("': ");
                writer.scope(CodeWriter.ScopeType.OBJECT, ", ", !operation.getParameters().isEmpty(), () -> {
                    Doc doc = operation.getDoc();
                    for (Parameter parameter : operation.getParameters()) {
                        writer.separator();
                        if (doc != null) {
                            writer.doc((String)doc.getParameterValueMap().get(parameter.getName()));
                        }
                        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.codeIf(!ctx.isMutable(), "readonly ")).code(parameter.isRequestBody() ? "body" : parameter.getName())).codeIf(parameter.getType() instanceof NullableType || parameter.getDefaultValue() != null, '?')).code(": ")).typeRef(parameter.getDefaultValue() != null ? NullableTypeImpl.of(parameter.getType()) : parameter.getType());
                    }
                });
            }
        });
        writer.code('\n');
    }
}

