/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.babyfish.jimmer.client.generator.GeneratorException;
import org.babyfish.jimmer.client.generator.NoMetadataException;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.runtime.ListType;
import org.babyfish.jimmer.client.runtime.MapType;
import org.babyfish.jimmer.client.runtime.Metadata;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Parameter;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.client.source.SourceManager;

public abstract class Context {
    private final Metadata metadata;
    private final String indent;
    SourceManager sourceManager;

    protected Context(Metadata metadata, String indent) {
        this.metadata = metadata;
        this.indent = indent != null && !indent.isEmpty() ? indent : "    ";
    }

    private void init() {
        if (this.sourceManager != null) {
            return;
        }
        this.sourceManager = this.createSourceManager();
        HashSet<Type> handledTypes = new HashSet<Type>();
        for (Service service : this.metadata.getServices()) {
            this.sourceManager.getSource(service);
            for (Operation operation : service.getOperations()) {
                this.sourceManager.getSource(operation);
                Type returnType = operation.getReturnType();
                if (returnType != null) {
                    this.initSource(returnType, handledTypes);
                }
                for (Parameter parameter : operation.getParameters()) {
                    this.initSource(parameter.getType(), handledTypes);
                }
                for (ObjectType exceptionType : operation.getExceptionTypes()) {
                    this.initSource(exceptionType, handledTypes);
                }
            }
        }
        this.sourceManager.createAdditionalSources();
    }

    private void initSource(Type type, Set<Type> handledTypes) {
        if (!handledTypes.add(type)) {
            return;
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            switch (objectType.getKind()) {
                case FETCHED: {
                    this.sourceManager.getSource(objectType);
                    return;
                }
                case DYNAMIC: 
                case EMBEDDABLE: 
                case STATIC: {
                    this.sourceManager.getSource(objectType);
                    for (Type argument : objectType.getArguments()) {
                        this.initSource(argument, handledTypes);
                    }
                    break;
                }
            }
            for (Property property : objectType.getProperties().values()) {
                this.initSource(property.getType(), handledTypes);
            }
        } else if (type instanceof NullableType) {
            this.initSource(((NullableType)type).getTargetType(), handledTypes);
        } else if (type instanceof ListType) {
            this.initSource(((ListType)type).getElementType(), handledTypes);
        } else if (type instanceof MapType) {
            this.initSource(((MapType)type).getKeyType(), handledTypes);
            this.initSource(((MapType)type).getValueType(), handledTypes);
        } else {
            this.sourceManager.getSource(type);
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getIndent() {
        return this.indent;
    }

    public Collection<Source> getRootSources() {
        this.init();
        return this.sourceManager.getRootSources();
    }

    public Source getRootSource(String name) {
        this.init();
        return this.sourceManager.getRootSource(name);
    }

    public Source getSource(Service service) {
        this.init();
        return this.sourceManager.getSource(service);
    }

    public Source getSource(Operation operation) {
        this.init();
        return this.sourceManager.getSource(operation);
    }

    public void renderAll(OutputStream outputStream) {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        try {
            this.renderAll(zipOutputStream);
            zipOutputStream.finish();
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot write source code into zip output stream", ex);
        }
    }

    private void renderAll(ZipOutputStream zipOutputStream) throws IOException {
        this.init();
        boolean hasOperation = false;
        for (Service service : this.metadata.getServices()) {
            if (service.getOperations().isEmpty()) continue;
            hasOperation = true;
            break;
        }
        if (!hasOperation) {
            throw new NoMetadataException();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipOutputStream, StandardCharsets.UTF_8);
        Map sourceMultiMap = this.sourceManager.getRootSources().stream().collect(Collectors.groupingBy(Source::getDirs, LinkedHashMap::new, Collectors.toList()));
        String suffix = '.' + this.getFileExtension();
        boolean isIndexRequired = this.isIndexRequired();
        for (Map.Entry e : sourceMultiMap.entrySet()) {
            String dir = String.join((CharSequence)"/", (Iterable)e.getKey());
            if (!dir.isEmpty()) {
                dir = dir + '/';
            }
            List sources = (List)e.getValue();
            if (isIndexRequired) {
                zipOutputStream.putNextEntry(new ZipEntry(dir + "index" + suffix));
                this.renderIndex(sources, (Writer)writer);
                ((Writer)writer).flush();
            }
            for (Source source : sources) {
                zipOutputStream.putNextEntry(new ZipEntry(dir + source.getName() + suffix));
                this.render(source, writer);
                ((Writer)writer).flush();
            }
        }
    }

    public void render(Source source, Writer writer) {
        this.init();
        SourceWriter codeWriter = this.createCodeWriter(this, source);
        StringWriter headWriter = new StringWriter();
        StringWriter bodyWriter = new StringWriter();
        codeWriter.setWriter(bodyWriter);
        source.getRender().render(codeWriter);
        codeWriter.setWriter(headWriter);
        codeWriter.onFlushImportedTypes();
        try {
            String head = headWriter.toString();
            if (!head.isEmpty()) {
                writer.write(head);
                writer.write(10);
            }
            writer.write(bodyWriter.toString());
        }
        catch (IOException ex) {
            throw new GeneratorException("Failed to write code for " + source);
        }
    }

    public void renderIndex(String dir, Writer writer) {
        if (!this.isIndexRequired()) {
            return;
        }
        this.init();
        List<String> dirs = SourceManager.dirs(dir);
        List<Source> sources = this.sourceManager.getRootSources().stream().filter(it -> it.getDirs().equals(dirs)).collect(Collectors.toList());
        this.renderIndex(sources, writer);
    }

    private void renderIndex(List<Source> sources, Writer writer) {
        StringWriter headWriter = new StringWriter();
        StringWriter bodyWriter = new StringWriter();
        for (Source source : sources) {
            SourceWriter codeWriter = this.createCodeWriter(this, source);
            codeWriter.setWriter(bodyWriter);
            source.getRender().export(codeWriter);
            codeWriter.setWriter(headWriter);
            codeWriter.onFlushImportedTypes();
        }
        try {
            String head = headWriter.toString();
            if (!head.isEmpty()) {
                writer.write(head);
                writer.write(10);
            }
            writer.write(bodyWriter.toString());
        }
        catch (IOException ex) {
            throw new GeneratorException("Failed to write index for " + String.join((CharSequence)"/", sources.get(0).getDirs()));
        }
    }

    protected abstract SourceManager createSourceManager();

    protected abstract SourceWriter createCodeWriter(Context var1, Source var2);

    protected boolean isIndexRequired() {
        return false;
    }

    protected abstract String getFileExtension();
}

