/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator;

import java.io.IOException;
import java.io.Writer;
import org.babyfish.jimmer.client.generator.GeneratorException;

public class CodeWriter<W extends CodeWriter<W>> {
    private final String indentText;
    private Writer writer;
    private int indent;
    private boolean lineDirty;
    private Scope scope;

    public CodeWriter(String indent) {
        this.indentText = indent;
    }

    public final W codeIf(boolean cond, String text) {
        if (cond) {
            return this.code(text);
        }
        return (W)this;
    }

    public final W codeIf(boolean cond, char c) {
        if (cond) {
            return this.code(c);
        }
        return (W)this;
    }

    public final W code(String text) {
        if (text.isEmpty()) {
            return (W)this;
        }
        int size = text.length();
        for (int i = 0; i < size; ++i) {
            this.doAdd(text.charAt(i));
        }
        return (W)this;
    }

    public final W code(char c) {
        this.doAdd(c);
        return (W)this;
    }

    private void doAdd(char c) {
        if (this.writer == null) {
            throw new GeneratorException("The target writer of CodeWriter has not been set");
        }
        try {
            if (!this.lineDirty) {
                for (int i = this.indent; i > 0; --i) {
                    this.writer.write(this.indentText);
                }
                this.lineDirty = true;
            }
            if (this.scope != null) {
                this.scope.dirty();
            }
            this.writer.write(c);
            if (c == '\n') {
                this.lineDirty = false;
            }
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot write code into writer", ex);
        }
    }

    public final W scope(ScopeType type, String separator, boolean multiLines, Runnable block) {
        Scope oldScope = this.scope;
        Scope newScope = new Scope(oldScope, separator, multiLines);
        this.code(type.prefix);
        if (multiLines) {
            this.code('\n');
        }
        ++this.indent;
        this.scope = newScope;
        block.run();
        --this.indent;
        if (multiLines && this.lineDirty) {
            this.code('\n');
        }
        this.code(type.suffix);
        this.scope = oldScope;
        return (W)this;
    }

    public final W separator() {
        Scope scope = this.scope;
        if (scope == null) {
            throw new IllegalStateException("There is no existing scope");
        }
        if (scope.dirty) {
            this.code(scope.separator);
            if (scope.multiLines) {
                this.code('\n');
            }
        }
        return (W)this;
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    private static class Scope {
        private final Scope parent;
        final String separator;
        final boolean multiLines;
        boolean dirty;

        Scope(Scope parent, String separator, boolean multiLines) {
            this.parent = parent;
            this.separator = separator;
            this.multiLines = multiLines;
        }

        void dirty() {
            if (!this.dirty) {
                this.dirty = true;
                if (this.parent != null) {
                    this.parent.dirty();
                }
            }
        }
    }

    public static enum ScopeType {
        OBJECT("{", "}"),
        LIST("[", "]"),
        ARGUMENTS("(", ")"),
        GENERIC("<", ">"),
        BLANK("", "");

        final String prefix;
        final String suffix;

        private ScopeType(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }
    }
}

