/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.NullRenderMode;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.ListType;
import org.babyfish.jimmer.client.runtime.MapType;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.SimpleType;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.TypeVariable;
import org.babyfish.jimmer.client.source.Source;

public class TypeScriptWriter
extends SourceWriter {
    private final NavigableMap<String, Import> imports = new TreeMap<String, Import>();
    private final boolean isMutable = ((TypeScriptContext)this.getContext()).isMutable();
    private final NullRenderMode nullRenderMode = ((TypeScriptContext)this.getContext()).getNullRenderMode();

    public TypeScriptWriter(Context ctx, Source source) {
        super(ctx, source);
    }

    @Override
    public SourceWriter typeRef(Type type) {
        if (type instanceof TypeVariable) {
            this.code(((TypeVariable)type).getName());
        } else if (type instanceof NullableType) {
            this.typeRef(((NullableType)type).getTargetType());
            if (this.nullRenderMode == NullRenderMode.NULL_OR_UNDEFINED) {
                this.code(" | null | undefined");
            } else {
                this.code(" | undefined");
            }
        } else if (type instanceof ListType) {
            ((SourceWriter)this.code(this.isMutable ? "Array<" : "ReadonlyArray<")).typeRef(((ListType)type).getElementType()).code('>');
        } else if (type instanceof MapType) {
            ((SourceWriter)this.code(this.isMutable ? "{[key:string]: " : "{readonly [key:string]: ")).typeRef(((MapType)type).getValueType()).code('}');
        } else if (type instanceof EnumType) {
            this.code(TypeScriptWriter.fullName(this.getSource(type)));
        } else if (type instanceof SimpleType) {
            Class<?> javaType = ((SimpleType)type).getJavaType();
            if (javaType == Boolean.TYPE) {
                this.code("boolean");
            } else if (javaType == Character.TYPE) {
                this.code("string");
            } else if (javaType.isPrimitive() || javaType == BigInteger.class || javaType == BigDecimal.class) {
                this.code("number");
            } else {
                this.code("string");
            }
        } else if (type instanceof ObjectType) {
            List<Type> arguments;
            this.code(TypeScriptWriter.fullName(this.getSource(type)));
            ObjectType objectType = (ObjectType)type;
            if (objectType.getKind() == ObjectType.Kind.STATIC && !(arguments = ((ObjectType)type).getArguments()).isEmpty()) {
                this.scope(CodeWriter.ScopeType.GENERIC, ", ", false, () -> {
                    for (Type argument : arguments) {
                        this.separator();
                        this.typeRef(argument);
                    }
                });
            }
        }
        return this;
    }

    @Override
    public void importSource(Source source, String name, boolean treatAsValue) {
        int sameCount;
        List<String> currentDirs = this.source.getDirs();
        List<String> dirs = source.getDirs();
        int maxCount = Math.min(currentDirs.size(), dirs.size());
        for (sameCount = 0; sameCount < maxCount && currentDirs.get(sameCount).equals(dirs.get(sameCount)); ++sameCount) {
        }
        StringBuilder builder = new StringBuilder();
        for (int i = currentDirs.size() - sameCount; i > 0; --i) {
            builder.append("../");
        }
        for (String dir : dirs.subList(sameCount, dirs.size())) {
            builder.append(dir).append('/');
        }
        String path = builder.toString();
        if (!path.startsWith("../")) {
            path = "./" + path;
        }
        Import imp = this.imports.computeIfAbsent(path, it -> new Import());
        if (treatAsValue) {
            imp.importedValues.add(name);
        } else {
            imp.importedTypes.add(name);
        }
    }

    @Override
    protected void onFlushImportedTypes() {
        for (Map.Entry e : this.imports.entrySet()) {
            NavigableSet<String> types = ((Import)e.getValue()).importedTypes;
            NavigableSet<String> values = ((Import)e.getValue()).importedValues;
            if (!types.isEmpty()) {
                this.code("import type ");
                this.scope(CodeWriter.ScopeType.OBJECT, ", ", types.size() > 3, () -> {
                    for (String name : types) {
                        this.separator();
                        this.code(name);
                    }
                });
                this.code(" from '");
                this.code((String)e.getKey());
                this.code("';\n");
            }
            if (values.isEmpty()) continue;
            this.code("import ");
            this.scope(CodeWriter.ScopeType.OBJECT, ", ", values.size() > 3, () -> {
                for (String name : values) {
                    this.separator();
                    this.code(name);
                }
            });
            this.code(" from '");
            this.code((String)e.getKey());
            this.code("';\n");
        }
    }

    private static String fullName(Source source) {
        if (source.getParent() == null) {
            return source.getName();
        }
        return TypeScriptWriter.fullName(source.getParent()) + "['" + source.getName() + "']";
    }

    private static class Import {
        final NavigableSet<String> importedTypes = new TreeSet<String>();
        final NavigableSet<String> importedValues = new TreeSet<String>();

        private Import() {
        }
    }
}

