/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.DocUtils;
import org.babyfish.jimmer.client.runtime.EnumType;

public class EnumTypeRender
implements Render {
    private final String name;
    private final EnumType enumType;

    public EnumTypeRender(String name, EnumType enumType) {
        this.name = name;
        this.enumType = enumType;
    }

    @Override
    public void export(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export type {")).code(this.name)).code("} from './")).code(this.name)).code("';\n");
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export {")).code(this.name)).code("_CONSTANTS} from './")).code(this.name)).code("';\n");
    }

    @Override
    public void render(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)writer.code("export const ")).code(this.name)).code("_CONSTANTS = ");
        writer.scope(CodeWriter.ScopeType.LIST, ", ", true, () -> {
            for (EnumType.Constant constant : this.enumType.getConstants()) {
                writer.separator();
                DocUtils.doc(constant.getDoc(), constant.getName(), this.enumType.getDoc(), writer);
                ((SourceWriter)((SourceWriter)writer.code('\'')).code(constant.getName())).code('\'');
            }
        });
        writer.code(" as const;\n");
        writer.doc(this.enumType.getDoc(), new SourceWriter.DocPart[0]);
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export type ")).code(this.name)).code(" = typeof ")).code(this.name)).code("_CONSTANTS[number];\n");
    }
}

