/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.openapi;

import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.client.generator.openapi.Description;
import org.babyfish.jimmer.client.generator.openapi.YmlWriter;

public class OpenApiProperties {
    private Info info;
    private List<Server> servers = Collections.emptyList();
    private List<Map<String, List<String>>> securities = Collections.emptyList();
    private Components components;

    public Info getInfo() {
        return this.info;
    }

    public OpenApiProperties setInfo(Info info) {
        this.info = info;
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public OpenApiProperties setServers(List<Server> servers) {
        this.servers = servers != null && !servers.isEmpty() ? Collections.unmodifiableList(servers) : Collections.emptyList();
        return this;
    }

    public List<Map<String, List<String>>> getSecurities() {
        return this.securities;
    }

    public OpenApiProperties setSecurities(List<Map<String, List<String>>> securities) {
        this.securities = securities != null && !securities.isEmpty() ? Collections.unmodifiableList(securities) : Collections.emptyList();
        return this;
    }

    public Components getComponents() {
        return this.components;
    }

    public OpenApiProperties setComponents(Components components) {
        this.components = components;
        return this;
    }

    public static class Info
    extends Node {
        private String title;
        private String description;
        private String termsOfService;
        private Contact contact;
        private License license;
        private String version;

        public String getTitle() {
            return this.title;
        }

        public Info setTitle(String title) {
            this.title = title;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Info setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getTermsOfService() {
            return this.termsOfService;
        }

        public Info setTermsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
            return this;
        }

        public Contact getContact() {
            return this.contact;
        }

        public Info setContact(Contact contact) {
            this.contact = contact;
            return this;
        }

        public License getLicense() {
            return this.license;
        }

        public Info setLicense(License license) {
            this.license = license;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Info setVersion(String version) {
            this.version = version;
            return this;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            writer.prop("title", this.title);
            writer.description(Description.of(this.description));
            writer.prop("termsOfService", this.termsOfService);
            Info.writeNodeTo("contact", this.contact, writer);
            Info.writeNodeTo("license", this.license, writer);
            writer.prop("version", this.version);
        }
    }

    public static class Components
    extends Node {
        private Map<String, SecurityScheme> securitySchemes = Collections.emptyMap();

        public Map<String, SecurityScheme> getSecuritySchemes() {
            return this.securitySchemes;
        }

        public Components setSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
            this.securitySchemes = securitySchemes != null && !securitySchemes.isEmpty() ? Collections.unmodifiableMap(securitySchemes) : Collections.emptyMap();
            return this;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            writer.object("securitySchemes", () -> {
                for (Map.Entry<String, SecurityScheme> e : this.securitySchemes.entrySet()) {
                    writer.object(e.getKey(), () -> ((SecurityScheme)e.getValue()).writeTo(writer));
                }
            });
        }
    }

    public static enum In {
        QUERY,
        HEADER,
        COOKIE;

    }

    public static class Flow
    extends Node {
        private String authorizationUrl;
        private String tokenUrl;
        private String refreshUrl;
        private Map<String, String> scopes = Collections.emptyMap();

        public String getAuthorizationUrl() {
            return this.authorizationUrl;
        }

        public void setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        public String getTokenUrl() {
            return this.tokenUrl;
        }

        public void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        public String getRefreshUrl() {
            return this.refreshUrl;
        }

        public void setRefreshUrl(String refreshUrl) {
            this.refreshUrl = refreshUrl;
        }

        public Map<String, String> getScopes() {
            return this.scopes;
        }

        public void setScopes(Map<String, String> scopes) {
            this.scopes = scopes != null && !scopes.isEmpty() ? Collections.unmodifiableMap(scopes) : Collections.emptyMap();
        }

        @Override
        public void writeTo(YmlWriter writer) {
            writer.prop("authorizationUrl", this.authorizationUrl);
            writer.prop("tokenUrl", this.tokenUrl);
            writer.prop("refreshUrl", this.refreshUrl);
            writer.object("scopes", () -> {
                for (Map.Entry<String, String> e : this.scopes.entrySet()) {
                    writer.prop(e.getKey(), e.getValue());
                }
            });
        }
    }

    public static class Flows
    extends Node {
        private Flow implicit;
        private Flow password;
        private Flow clientCredentials;
        private Flow authorizationCode;

        public Flow getImplicit() {
            return this.implicit;
        }

        public void setImplicit(Flow implicit) {
            this.implicit = implicit;
        }

        public Flow getPassword() {
            return this.password;
        }

        public void setPassword(Flow password) {
            this.password = password;
        }

        public Flow getClientCredentials() {
            return this.clientCredentials;
        }

        public void setClientCredentials(Flow clientCredentials) {
            this.clientCredentials = clientCredentials;
        }

        public Flow getAuthorizationCode() {
            return this.authorizationCode;
        }

        public void setAuthorizationCode(Flow authorizationCode) {
            this.authorizationCode = authorizationCode;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            Flows.writeNodeTo("implicit", this.implicit, writer);
            Flows.writeNodeTo("password", this.password, writer);
            Flows.writeNodeTo("clientCredentials", this.clientCredentials, writer);
            Flows.writeNodeTo("authorizationCode", this.authorizationCode, writer);
        }
    }

    public static class SecurityScheme
    extends Node {
        private String type;
        private String description;
        private String name;
        private In in = In.HEADER;
        private String scheme;
        private String bearerFormat;
        private Flows flows;
        private String openIdConnectUrl;

        public String getType() {
            return this.type;
        }

        public SecurityScheme setType(String type) {
            this.type = type;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public SecurityScheme setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public SecurityScheme setName(String name) {
            this.name = name;
            return this;
        }

        public In getIn() {
            return this.in;
        }

        public SecurityScheme setIn(In in) {
            this.in = in != null ? in : In.HEADER;
            return this;
        }

        public String getScheme() {
            return this.scheme;
        }

        public SecurityScheme setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public String getBearerFormat() {
            return this.bearerFormat;
        }

        public SecurityScheme setBearerFormat(String bearerFormat) {
            this.bearerFormat = bearerFormat;
            return this;
        }

        public Flows getFlows() {
            return this.flows;
        }

        public SecurityScheme setFlows(Flows flows) {
            this.flows = flows;
            return this;
        }

        public String getOpenIdConnectUrl() {
            return this.openIdConnectUrl;
        }

        public SecurityScheme setOpenIdConnectUrl(String openIdConnectUrl) {
            this.openIdConnectUrl = openIdConnectUrl;
            return this;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            writer.prop("type", this.type);
            writer.prop("description", this.description);
            writer.prop("name", this.name);
            writer.prop("in", this.in.name().toLowerCase());
            writer.prop("scheme", this.scheme);
            writer.prop("bearerFormat", this.bearerFormat);
            SecurityScheme.writeNodeTo("flows", this.flows, writer);
            writer.prop("openIdConnectUrl", this.openIdConnectUrl);
        }
    }

    public static class Variable
    extends Node {
        private List<String> enums = Collections.emptyList();
        private String defaultValue;
        private String description;

        public List<String> getEnums() {
            return this.enums;
        }

        public void setEnums(List<String> enums) {
            this.enums = enums != null && enums.isEmpty() ? enums : Collections.emptyList();
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            if (!this.enums.isEmpty()) {
                writer.list("enum", () -> {
                    for (String en : this.enums) {
                        writer.listItem(() -> ((YmlWriter)writer.code(en)).code('\n'));
                    }
                });
            }
            writer.prop("default", this.defaultValue);
            writer.prop("description", this.description);
        }
    }

    public static class Server
    extends Node {
        private String url;
        private String description;
        private Map<String, Variable> variables = Collections.emptyMap();

        public String getUrl() {
            return this.url;
        }

        public Server setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Server setDescription(String description) {
            this.description = description;
            return this;
        }

        public Map<String, Variable> getVariables() {
            return this.variables;
        }

        public Server setVariables(Map<String, Variable> variables) {
            this.variables = variables != null && !variables.isEmpty() ? Collections.unmodifiableMap(variables) : Collections.emptyMap();
            return this;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            writer.prop("url", this.url);
            writer.prop("description", this.description);
            if (!this.variables.isEmpty()) {
                for (Map.Entry<String, Variable> e : this.variables.entrySet()) {
                    writer.object(e.getKey(), () -> ((Variable)e.getValue()).writeTo(writer));
                }
            }
        }
    }

    public static class License
    extends Node {
        private String name;
        private String identifier;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            writer.prop("name", this.name);
            writer.prop("identifier", this.identifier);
        }
    }

    public static class Contact
    extends Node {
        private String name;
        private String url;
        private String email;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        @Override
        public void writeTo(YmlWriter writer) {
            writer.prop("name", this.name);
            writer.prop("url", this.url);
            writer.prop("email", this.email);
        }
    }

    public static abstract class Node {
        public abstract void writeTo(YmlWriter var1);

        public String toString() {
            StringWriter writer = new StringWriter();
            YmlWriter ymlWriter = new YmlWriter(writer);
            this.writeTo(ymlWriter);
            return writer.toString();
        }

        public static void writeNodeTo(String objectName, Node node, YmlWriter writer) {
            if (node != null) {
                writer.object(objectName, () -> node.writeTo(writer));
            }
        }
    }
}

