/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.Map;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.DocUtils;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.ListType;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.impl.FetchedTypeImpl;

public class FetchedTypeRender
implements Render {
    private final String name;
    private final ObjectType objectType;
    final Map<Type, String> recursiveTypeNames;

    public FetchedTypeRender(String name, ObjectType objectType, Map<Type, String> recursiveTypeNames) {
        this.name = name;
        this.objectType = objectType;
        this.recursiveTypeNames = recursiveTypeNames;
        this.collectRecursiveTypeNames(objectType);
    }

    private void collectRecursiveTypeNames(ObjectType type) {
        if (type.isRecursiveFetchedType()) {
            if (this.recursiveTypeNames.containsKey(type)) {
                return;
            }
            this.recursiveTypeNames.put(type, "RecursiveType_" + (this.recursiveTypeNames.size() + 1));
        }
        for (Property property : type.getProperties().values()) {
            boolean isList;
            Type targetType = property.getType();
            boolean isNullable = targetType instanceof NullableType;
            if (isNullable) {
                targetType = ((NullableType)targetType).getTargetType();
            }
            if (isList = targetType instanceof ListType) {
                targetType = ((ListType)targetType).getElementType();
            }
            if (!(targetType instanceof ObjectType)) continue;
            this.collectRecursiveTypeNames((ObjectType)targetType);
        }
    }

    @Override
    public void render(SourceWriter writer) {
        assert (this.objectType.getFetchByInfo() != null);
        Doc doc = this.objectType.getFetchByInfo().getDoc();
        if (doc == null) {
            doc = this.objectType.getDoc();
        }
        writer.doc(doc, new SourceWriter.DocPart[0]);
        ((SourceWriter)((SourceWriter)writer.code('\'')).code(this.name)).code("': ");
        FetchedTypeRender.render(this.objectType, writer, this.recursiveTypeNames);
        writer.code('\n');
    }

    static void render(ObjectType type, SourceWriter writer, Map<Type, String> recursiveTypeNames) {
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Property property : type.getProperties().values()) {
                boolean isList;
                DocUtils.doc(property, type.getDoc(), writer);
                ((SourceWriter)writer.codeIf(!ctx.isMutable(), "readonly ")).code(property.getName());
                Type targetType = property.getType();
                boolean isNullable = targetType instanceof NullableType;
                if (isNullable) {
                    targetType = ((NullableType)targetType).getTargetType();
                }
                if (isList = targetType instanceof ListType) {
                    targetType = ((ListType)targetType).getElementType();
                }
                String recursiveTypeName = (String)recursiveTypeNames.get(targetType);
                ((SourceWriter)writer.codeIf(property.getType() instanceof NullableType || recursiveTypeName != null, '?')).code(": ");
                if (targetType instanceof FetchedTypeImpl) {
                    ObjectType targetObjectType = (ObjectType)targetType;
                    FetchedTypeRender.writeResolvedType(writer, isNullable, isList, () -> {
                        if (recursiveTypeName != null) {
                            writer.code(recursiveTypeName);
                        } else {
                            FetchedTypeRender.render(targetObjectType, writer, recursiveTypeNames);
                        }
                    });
                } else {
                    writer.typeRef(property.getType());
                }
                writer.codeIf(recursiveTypeName != null, " | null | undefined");
                writer.code(";\n");
            }
        });
    }

    private static void writeResolvedType(SourceWriter writer, boolean isNullable, boolean isList, Runnable block) {
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        if (isList) {
            writer.code(ctx.isMutable() ? "Array<" : "ReadonlyArray<");
        }
        block.run();
        if (isList) {
            writer.code('>');
        }
        if (isNullable) {
            writer.code(" | null | undefined");
        }
    }
}

