/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.babyfish.jimmer.client.ThrowsAll;
import org.babyfish.jimmer.client.meta.EnumBasedError;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.error.ErrorFamily;
import org.babyfish.jimmer.impl.util.StaticCache;

public class Throws {
    private static StaticCache<Class<?>, Method> ANNOTATION_VALUE_METHOD_CACHE = new StaticCache(Throws::parseAnnotationValueMethod, true);
    private final Context ctx;

    public Throws(Context ctx) {
        this.ctx = ctx;
    }

    public Collection<EnumBasedError> getErrors(Method operationMethod) {
        LinkedHashSet<EnumBasedError> errors = new LinkedHashSet<EnumBasedError>();
        ThrowsAll throwsAll = operationMethod.getAnnotation(ThrowsAll.class);
        if (throwsAll != null) {
            for (Enum<?> constant : throwsAll.value().getEnumConstants()) {
                errors.add(this.ctx.getError(constant));
            }
        }
        for (Annotation annotation : operationMethod.getAnnotations()) {
            Object[] arr;
            Method valueMethod;
            if (annotation.annotationType() == ThrowsAll.class || (valueMethod = (Method)ANNOTATION_VALUE_METHOD_CACHE.get(annotation.annotationType())) == null) continue;
            try {
                arr = (Object[])valueMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError("Internal bug, can not get error code from \"" + valueMethod + "\"", ex);
            }
            catch (InvocationTargetException ex) {
                throw new AssertionError("Internal bug, can not get error code from \"" + valueMethod + "\"", ex.getTargetException());
            }
            for (Object o : arr) {
                errors.add(this.ctx.getError((Enum)o));
            }
        }
        return errors;
    }

    private static Method parseAnnotationValueMethod(Class<?> annotationType) {
        Method valueMethod;
        try {
            valueMethod = annotationType.getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (!valueMethod.getReturnType().isArray()) {
            return null;
        }
        Class<?> errorType = valueMethod.getReturnType().getComponentType();
        if (!errorType.isEnum() || !errorType.isAnnotationPresent(ErrorFamily.class)) {
            return null;
        }
        return valueMethod;
    }
}

