/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.jimmer.client.FetchBy;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.FetchByInfo;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.ObjectType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.Visitor;
import org.babyfish.jimmer.client.meta.impl.ArrayTypeImpl;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.client.meta.impl.DocumentImpl;
import org.babyfish.jimmer.client.meta.impl.NullableTypeImpl;
import org.babyfish.jimmer.client.meta.impl.PropertyImpl;
import org.babyfish.jimmer.jackson.meta.ConverterMetadata;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.spi.ImmutablePropImplementor;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.jetbrains.annotations.Nullable;

public class ImmutableObjectTypeImpl
implements ImmutableObjectType {
    private final ImmutableType immutableType;
    private final ImmutableObjectType.Category category;
    private final Fetcher<?> fetcher;
    private final FetchByInfo fetchByInfo;
    private final Document document;
    private Map<String, Property> props;

    private ImmutableObjectTypeImpl(ImmutableType immutableType, Fetcher<?> fetcher, FetchByInfo fetchByInfo) {
        this.immutableType = immutableType;
        this.category = ImmutableObjectType.Category.FETCH;
        this.fetcher = fetcher;
        this.fetchByInfo = fetchByInfo;
        this.document = DocumentImpl.of(immutableType.getJavaClass());
    }

    private ImmutableObjectTypeImpl(ImmutableType immutableType, ImmutableObjectType.Category category) {
        this.immutableType = immutableType;
        this.category = category;
        this.fetcher = null;
        this.fetchByInfo = null;
        this.document = DocumentImpl.of(immutableType.getJavaClass());
    }

    private ImmutableObjectTypeImpl(ImmutableType immutableType, boolean anonymous, ImmutableObjectType.Category category, Map<String, Property> props) {
        this.immutableType = immutableType;
        this.category = category;
        this.fetcher = null;
        this.fetchByInfo = null;
        this.props = props;
        this.document = DocumentImpl.of(immutableType.getJavaClass());
    }

    @Override
    public Class<?> getJavaType() {
        return this.immutableType.getJavaClass();
    }

    @Override
    public boolean isEntity() {
        return this.immutableType.isEntity();
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.props;
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public ImmutableObjectType.Category getCategory() {
        return this.category;
    }

    @Override
    public FetchByInfo getFetchByInfo() {
        return this.fetchByInfo;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.document;
    }

    Fetcher<?> getFetcher() {
        return this.fetcher;
    }

    FetchByInfo fetchByInfo() {
        return this.fetchByInfo;
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.isTypeVisitable(this)) {
            visitor.visitImmutableObjectType(this);
            for (Property prop : this.props.values()) {
                prop.getType().accept(visitor);
            }
        }
    }

    public String toString() {
        if (this.category == ImmutableObjectType.Category.VIEW) {
            return "@view:" + this.immutableType;
        }
        if (this.category == ImmutableObjectType.Category.RAW) {
            return "@raw:" + this.immutableType;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean addComma = false;
        for (Property prop : this.props.values()) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(prop.getName()).append(": ").append(prop.getType());
        }
        builder.append("}");
        return builder.toString();
    }

    static ImmutableObjectType fetch(Context ctx, ImmutableType immutableType, Fetcher<?> fetcher, FetchByInfo info) {
        ImmutableObjectTypeImpl impl;
        if (info != null && (impl = (ImmutableObjectTypeImpl)ctx.getImmutableObjectType(ImmutableObjectType.Category.FETCH, immutableType, fetcher)) != null) {
            return impl;
        }
        if (info != null && !immutableType.getJavaClass().getName().equals(fetcher.getImmutableType().getJavaClass().getName())) {
            throw new IllegalDocMetaException("Illegal " + ctx.getLocation() + ", @" + FetchBy.class.getName() + " specifies a fetcher whose type is \"" + fetcher.getImmutableType() + "\", but the decorated type is \"" + immutableType + "\"");
        }
        impl = new ImmutableObjectTypeImpl(fetcher.getImmutableType(), fetcher, info);
        if (info != null) {
            ctx.addImmutableObjectType(impl);
        }
        LinkedHashMap<String, Property> props = new LinkedHashMap<String, Property>();
        for (Field field : fetcher.getFieldMap().values()) {
            if (field.isImplicit()) continue;
            ImmutableProp prop = field.getProp();
            if (prop.isAssociation(TargetLevel.ENTITY)) {
                Fetcher childFetcher = field.getChildFetcher();
                if (childFetcher == null) {
                    childFetcher = new FetcherImpl(prop.getTargetType().getJavaClass());
                }
                Type type = ImmutableObjectTypeImpl.fetch(ctx, prop.getTargetType(), childFetcher, null);
                if (prop.isNullable() && field.getRecursionStrategy() == null) {
                    type = NullableTypeImpl.of(type);
                }
                if (prop.isReferenceList(TargetLevel.ENTITY)) {
                    type = new ArrayTypeImpl(type);
                }
                props.put(prop.getName(), new PropertyImpl(prop.getName(), type, DocumentImpl.of(prop)));
                continue;
            }
            props.put(prop.getName(), ImmutableObjectTypeImpl.property(ctx, prop));
        }
        impl.props = Collections.unmodifiableMap(props);
        return impl;
    }

    static ImmutableObjectType view(Context ctx, ImmutableType immutableType) {
        ImmutableObjectTypeImpl impl = (ImmutableObjectTypeImpl)ctx.getImmutableObjectType(ImmutableObjectType.Category.VIEW, immutableType, null);
        if (impl != null) {
            return impl;
        }
        impl = new ImmutableObjectTypeImpl(immutableType, ImmutableObjectType.Category.VIEW);
        ctx.addImmutableObjectType(impl);
        LinkedHashMap<String, Property> props = new LinkedHashMap<String, Property>();
        for (ImmutableProp prop : immutableType.getProps().values()) {
            if (!immutableType.isEmbeddable() && !prop.hasStorage()) continue;
            if (prop.isAssociation(TargetLevel.ENTITY)) {
                Type type = ImmutableObjectTypeImpl.idOnly(ctx, prop.getTargetType());
                if (prop.isNullable()) {
                    type = NullableTypeImpl.of(type);
                }
                if (prop.isReferenceList(TargetLevel.ENTITY)) {
                    type = new ArrayTypeImpl(type);
                }
                props.put(prop.getName(), new PropertyImpl(prop.getName(), type, DocumentImpl.of(prop)));
                continue;
            }
            props.put(prop.getName(), ImmutableObjectTypeImpl.property(ctx, prop));
        }
        impl.props = Collections.unmodifiableMap(props);
        return impl;
    }

    static ImmutableObjectType raw(Context ctx, ImmutableType immutableType) {
        ImmutableObjectTypeImpl impl = (ImmutableObjectTypeImpl)ctx.getImmutableObjectType(ImmutableObjectType.Category.RAW, immutableType, null);
        if (impl != null) {
            return impl;
        }
        impl = new ImmutableObjectTypeImpl(immutableType, ImmutableObjectType.Category.RAW);
        ctx.addImmutableObjectType(impl);
        LinkedHashMap<String, Property> props = new LinkedHashMap<String, Property>();
        for (ImmutableProp prop : immutableType.getProps().values()) {
            props.put(prop.getName(), ImmutableObjectTypeImpl.property(ctx, prop));
        }
        impl.props = Collections.unmodifiableMap(props);
        return impl;
    }

    static ObjectType idOnly(Context ctx, ImmutableType immutableType) {
        LinkedHashMap<String, PropertyImpl> props = new LinkedHashMap<String, PropertyImpl>();
        ImmutableProp idProp = immutableType.getIdProp();
        Type type = ctx.parseType(((ImmutablePropImplementor)idProp).getJavaGetter().getAnnotatedReturnType());
        props.put(idProp.getName(), new PropertyImpl(idProp.getName(), type, DocumentImpl.of(idProp)));
        return new ImmutableObjectTypeImpl(immutableType, true, ImmutableObjectType.Category.FETCH, Collections.unmodifiableMap(props));
    }

    private static Property property(Context ctx, ImmutableProp prop) {
        ConverterMetadata metadata = prop.getConverterMetadata();
        Type type = metadata != null ? ctx.parseConvertedType(metadata.getTargetType()) : ctx.parseType(((ImmutablePropImplementor)prop).getJavaGetter().getAnnotatedReturnType());
        if (prop.isNullable()) {
            type = NullableTypeImpl.of(type);
        }
        return new PropertyImpl(prop.getName(), type, DocumentImpl.of(prop));
    }
}

