/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.client.NotApi;
import org.babyfish.jimmer.client.meta.Document;
import org.babyfish.jimmer.client.meta.EnumBasedError;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Parameter;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.Type;
import org.babyfish.jimmer.client.meta.Visitor;
import org.babyfish.jimmer.client.meta.impl.Context;
import org.babyfish.jimmer.client.meta.impl.DocumentImpl;
import org.babyfish.jimmer.client.meta.impl.JetBrainsMetadata;
import org.babyfish.jimmer.client.meta.impl.Location;
import org.babyfish.jimmer.client.meta.impl.NullableTypeImpl;
import org.babyfish.jimmer.client.meta.impl.ParameterImpl;
import org.babyfish.jimmer.client.meta.impl.Throws;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.jetbrains.annotations.Nullable;

class OperationImpl
implements Operation {
    private final Service declaringService;
    private final Method rawMethod;
    private final String uri;
    private final Operation.HttpMethod httpMethod;
    private final Type type;
    private final Collection<EnumBasedError> errors;
    private final Document document;
    List<Parameter> parameters;

    OperationImpl(Service declaringService, Method rawMethod, String uri, Operation.HttpMethod method, Type type, Collection<EnumBasedError> errors) {
        this.declaringService = declaringService;
        this.rawMethod = rawMethod;
        this.uri = uri;
        this.httpMethod = method;
        this.type = type;
        this.errors = errors;
        this.document = DocumentImpl.of(rawMethod);
    }

    @Override
    public Service getDeclaringService() {
        return this.declaringService;
    }

    @Override
    public String getName() {
        return this.rawMethod.getName();
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public Operation.HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public Method getRawMethod() {
        return this.rawMethod;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Collection<EnumBasedError> getErrors() {
        return this.errors;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitingOperation(this);
        for (Parameter parameter : this.parameters) {
            parameter.accept(visitor);
        }
        this.type.accept(visitor);
        for (EnumBasedError error : this.errors) {
            for (EnumBasedError.Field field : error.getFields().values()) {
                field.getType().accept(visitor);
            }
        }
        visitor.visitedOperation(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append('(');
        boolean addComma = false;
        for (Parameter parameter : this.parameters) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(parameter);
        }
        builder.append("): ").append(this.getType());
        return builder.toString();
    }

    @Nullable
    static Operation create(Context ctx, Service declaringService, Method rawMethod) {
        long requestBodyCount;
        Type type;
        Operation.HttpMethod httpMethod;
        String parentUri;
        if (rawMethod.isAnnotationPresent(NotApi.class)) {
            return null;
        }
        Tuple2<String, Operation.HttpMethod> http = ctx.getOperationParser().http(rawMethod);
        if (http == null) {
            return null;
        }
        String uri = (String)http.get_1();
        if (uri == null || uri.isEmpty()) {
            uri = "/";
        }
        if ((parentUri = declaringService.getUri()) != null) {
            uri = parentUri.endsWith("/") && uri.startsWith("/") ? parentUri + uri.substring(1) : (!parentUri.endsWith("/") && !uri.startsWith("/") ? parentUri + '/' + uri : parentUri + uri);
        }
        if ((httpMethod = (Operation.HttpMethod)((Object)http.get_2())) == null) {
            httpMethod = declaringService.getDefaultMethod();
        }
        Context subContext = ctx.locate(new OperationLocation(rawMethod, httpMethod));
        JetBrainsMetadata jetBrainsMetadata = ctx.getJetBrainsMetadata(rawMethod.getDeclaringClass());
        Type type2 = type = jetBrainsMetadata.isKotlinClass() ? subContext.parseKotlinType(ctx.getOperationParser().kotlinType(jetBrainsMetadata.toKFunction(rawMethod))) : subContext.parseType(ctx.getOperationParser().javaType(rawMethod));
        if (jetBrainsMetadata.isNullable(rawMethod)) {
            type = NullableTypeImpl.of(type);
        }
        OperationImpl operation = new OperationImpl(declaringService, rawMethod, uri, httpMethod, type, new Throws(ctx).getErrors(rawMethod));
        int index = 0;
        String[] parameterNames = ctx.getOperationParser().getParameterNames(rawMethod);
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        java.lang.reflect.Parameter[] rawParameters = rawMethod.getParameters();
        for (int i = 0; i < rawParameters.length; ++i) {
            Parameter parameter = ParameterImpl.create(ctx, operation, rawParameters[i], parameterNames != null && parameterNames.length != 0 ? parameterNames[i] : null, index++);
            if (parameter == null) continue;
            list.add(parameter);
        }
        if (list.size() > 1 && (requestBodyCount = list.stream().filter(Parameter::isRequestBody).count()) > 1L) {
            throw new IllegalDocMetaException("Illegal method \"" + rawMethod + "\", can only contain one request body parameter");
        }
        operation.parameters = Collections.unmodifiableList(list);
        HashSet<String> names = new HashSet<String>();
        for (Parameter parameter : list) {
            if (names.add(parameter.getName())) continue;
            throw new IllegalDocMetaException("Illegal method \"" + rawMethod + "\", duplicated parameter name \"" + parameter.getName() + "\"(web parameter name, not java parameter name)");
        }
        return operation;
    }

    private static class OperationLocation
    implements Location {
        private final Method rawMethod;
        private final Operation.HttpMethod httpMethod;

        private OperationLocation(Method rawMethod, Operation.HttpMethod httpMethod) {
            this.rawMethod = rawMethod;
            this.httpMethod = httpMethod;
        }

        @Override
        public boolean isQueryResult() {
            return this.httpMethod == Operation.HttpMethod.GET;
        }

        @Override
        public Class<?> getDeclaringType() {
            return this.rawMethod.getDeclaringClass();
        }

        public String toString() {
            return "return type of " + this.rawMethod;
        }
    }
}

