/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.generator.ts.DtoWriter;
import org.babyfish.jimmer.client.generator.ts.TsContext;
import org.babyfish.jimmer.client.generator.ts.simple.DynamicWriter;
import org.babyfish.jimmer.client.meta.ArrayType;
import org.babyfish.jimmer.client.meta.ImmutableObjectType;
import org.babyfish.jimmer.client.meta.MapType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.SimpleType;

public abstract class TsCodeWriter
extends CodeWriter<TsContext> {
    public static final Map<Class<?>, String> SIMPLE_TYPE_NAMES;
    private static final String[] EMPTY_ARR;
    private static final Pattern SLASH_PATTERN;
    private final Map<String, Set<String>> importMap = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> importDataMap = new TreeMap<String, Set<String>>();
    protected final boolean mutable;

    protected TsCodeWriter(TsContext ctx, File file, boolean mutable) {
        super(ctx, file);
        this.mutable = mutable;
    }

    @Override
    public void onImport(File file, boolean treatAsData, List<String> nestedNames) {
        int i;
        int sameCount;
        String[] currentPaths = this.file.getDir().isEmpty() ? EMPTY_ARR : SLASH_PATTERN.split(this.file.getDir());
        String[] paths = file.getDir().isEmpty() ? EMPTY_ARR : SLASH_PATTERN.split(file.getDir());
        int len = Math.min(currentPaths.length, paths.length);
        for (sameCount = 0; sameCount < len && currentPaths[sameCount].equals(paths[sameCount]); ++sameCount) {
        }
        StringBuilder builder = new StringBuilder();
        if (sameCount < currentPaths.length) {
            for (i = currentPaths.length - sameCount; i > 0; --i) {
                builder.append("..");
                if (i == 1) continue;
                builder.append('/');
            }
        } else {
            builder.append(".");
        }
        if (sameCount == paths.length) {
            builder.append('/');
        }
        for (i = sameCount; i < paths.length; ++i) {
            builder.append('/').append(paths[i]);
        }
        String path = builder.toString();
        StringBuilder realName = new StringBuilder(file.getName());
        if (nestedNames != null) {
            String sp = ((TsContext)this.ctx).nestedTypeSeparator();
            for (String nestedName : nestedNames) {
                realName.append(sp);
                realName.append(nestedName);
            }
        }
        (treatAsData ? this.importDataMap : this.importMap).computeIfAbsent(path, it -> new TreeSet()).add(realName.toString());
    }

    @Override
    protected void writeImportHeader(Writer writer) throws IOException {
        TsCodeWriter.applyImportMap(this.importMap, false, writer);
        TsCodeWriter.applyImportMap(this.importDataMap, true, writer);
    }

    private static void applyImportMap(Map<String, Set<String>> importMap, boolean treatAsData, Writer writer) throws IOException {
        if (!importMap.isEmpty()) {
            for (Map.Entry<String, Set<String>> e : importMap.entrySet()) {
                writer.write(treatAsData ? "import { " : "import type { ");
                boolean addComma = false;
                for (String name : e.getValue()) {
                    if (addComma) {
                        writer.write(", ");
                    } else {
                        addComma = true;
                    }
                    writer.write(name);
                }
                writer.write(" } from '");
                writer.write(e.getKey());
                writer.write("';\n");
            }
            writer.write(10);
        }
    }

    @Override
    protected void writeSimpleTypeRef(SimpleType simpleType) {
        String name = SIMPLE_TYPE_NAMES.get(simpleType.getJavaType());
        if (name == null) {
            name = "any";
        }
        this.code(name);
    }

    @Override
    protected void writeNullableTypeRef(NullableType nullableType) {
        this.typeRef(nullableType.getTargetType());
        this.code(" | undefined");
    }

    @Override
    protected void writeArrayTypeRef(ArrayType arrayType) {
        this.code(this.mutable ? "Array<" : "ReadonlyArray<");
        this.typeRef(arrayType.getElementType());
        this.code(">");
    }

    @Override
    protected void writeMapTypeRef(MapType mapType) {
        this.code(this.mutable ? "{" : "{readonly ");
        this.code("[key:string]: ");
        this.typeRef(mapType.getValueType());
        this.code("}");
    }

    @Override
    protected void writeDynamicTypeRef(ImmutableObjectType type) {
        this.importFile(DynamicWriter.FILE);
        this.code("Dynamic<").code(((TsContext)this.getContext()).getFile(type).getName()).code('>');
    }

    @Override
    protected void writeDtoTypeRef(ImmutableObjectType type) {
        TsContext ctx = (TsContext)this.getContext();
        if (!ctx.isAnonymous() && type.getFetchByInfo() != null) {
            this.importFile(DtoWriter.dtoFile(ctx, type.getJavaType()));
            this.code(ctx.getDtoPrefix(type.getJavaType())).code("['").code(ctx.getDtoSuffix(type)).code("']");
        } else if (!ctx.isAnonymous() && type.getCategory() == ImmutableObjectType.Category.VIEW) {
            this.importFile(DtoWriter.dtoFile(ctx, type.getJavaType()));
            this.code(ctx.getDtoPrefix(type.getJavaType())).code("['DEFAULT']");
        } else {
            this.scope(CodeWriter.ScopeType.OBJECT, ", ", type.getProperties().size() > 1, () -> {
                for (Property property : type.getProperties().values()) {
                    this.separator();
                    if (property.getDocument() != null) {
                        this.code('\n');
                        this.document(property.getDocument());
                    }
                    this.codeIf(!this.mutable, "readonly ").code(property.getName()).codeIf(property.getType() instanceof NullableType, "?").code(": ");
                    this.typeRef(NullableType.unwrap(property.getType()));
                }
            });
        }
    }

    static {
        EMPTY_ARR = new String[0];
        SLASH_PATTERN = Pattern.compile("/");
        HashMap map = new HashMap();
        map.put(Void.TYPE, "void");
        map.put(Boolean.TYPE, "boolean");
        map.put(Boolean.class, "boolean");
        map.put(Character.TYPE, "number");
        map.put(Character.class, "number");
        map.put(Byte.TYPE, "number");
        map.put(Byte.class, "number");
        map.put(Short.TYPE, "number");
        map.put(Short.class, "number");
        map.put(Integer.TYPE, "number");
        map.put(Integer.class, "number");
        map.put(Long.TYPE, "number");
        map.put(Long.class, "number");
        map.put(Float.TYPE, "number");
        map.put(Float.class, "number");
        map.put(Double.TYPE, "number");
        map.put(Double.class, "number");
        map.put(BigInteger.class, "number");
        map.put(BigDecimal.class, "number");
        map.put(String.class, "string");
        map.put(UUID.class, "string");
        map.put(java.util.Date.class, "string");
        map.put(Date.class, "string");
        map.put(Time.class, "string");
        map.put(Timestamp.class, "string");
        map.put(LocalDate.class, "string");
        map.put(LocalTime.class, "string");
        map.put(LocalDateTime.class, "string");
        map.put(OffsetDateTime.class, "string");
        map.put(ZonedDateTime.class, "string");
        SIMPLE_TYPE_NAMES = map;
    }
}

