/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.babyfish.jimmer.client.IllegalDocMetaException;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.ts.TsCodeWriter;
import org.babyfish.jimmer.client.generator.ts.TsContext;
import org.babyfish.jimmer.client.generator.ts.simple.ExecutorWriter;
import org.babyfish.jimmer.client.meta.ArrayType;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.NullableType;
import org.babyfish.jimmer.client.meta.ObjectType;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.client.meta.Parameter;
import org.babyfish.jimmer.client.meta.Property;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.SimpleType;
import org.babyfish.jimmer.client.meta.Type;

public class ServiceWriter
extends TsCodeWriter {
    private final Service service;

    public ServiceWriter(TsContext ctx, Service service, boolean mutable) {
        super(ctx, ctx.getFile(service), mutable);
        this.service = service;
    }

    @Override
    protected void write() {
        this.importFile(ExecutorWriter.FILE);
        this.document(this.service.getDocument());
        this.code("export class ").code(this.getFile().getName()).code(' ');
        this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            this.code("\nconstructor(private executor: Executor) {}\n");
            for (Operation operation : this.service.getOperations()) {
                this.write(operation);
            }
        });
        if (!((TsContext)this.getContext()).isAnonymous()) {
            this.code('\n');
            this.code("\nexport type ").code(this.getFile().getName()).code("Options = ");
            this.scope(CodeWriter.ScopeType.OBJECT, ",", true, () -> {
                for (Operation operation : this.service.getOperations()) {
                    this.separator();
                    this.code('\'').code(((TsContext)this.getContext()).getOperationName(operation)).code("': ");
                    this.optionsBody(operation);
                }
            });
        }
    }

    private void write(Operation operation) {
        this.code('\n');
        this.document(operation.getDocument());
        this.code("async ").code(((TsContext)this.getContext()).getOperationName(operation)).scope(CodeWriter.ScopeType.ARGUMENTS, "", false, () -> {
            if (!operation.getParameters().isEmpty()) {
                this.code("options");
                this.code(": ");
                if (((TsContext)this.getContext()).isAnonymous()) {
                    this.optionsBody(operation);
                } else {
                    this.optionsName(operation);
                }
            }
        }).code(": Promise").scope(CodeWriter.ScopeType.GENERIC, ", ", !(NullableType.unwrap(operation.getType()) instanceof SimpleType), () -> this.typeRef(operation.getType())).code(" ").scope(CodeWriter.ScopeType.OBJECT, "", true, () -> this.impl(operation)).code('\n');
    }

    private void write(Parameter parameter) {
        this.codeIf(!this.mutable, "readonly ").code(parameter.getName()).codeIf(parameter.getType() instanceof NullableType, '?').code(": ").typeRef(NullableType.unwrap(parameter.getType()));
    }

    private void optionsName(Operation operation) {
        this.code(this.getFile().getName()).code("Options['").code(((TsContext)this.getContext()).getOperationName(operation)).code("']");
    }

    private void optionsBody(Operation operation) {
        this.scope(CodeWriter.ScopeType.OBJECT, ", ", operation.getParameters().size() > 2, () -> {
            for (Parameter parameter : operation.getParameters()) {
                this.separator();
                if (parameter.getDocument() != null) {
                    this.code('\n');
                    this.document(parameter.getDocument());
                }
                this.write(parameter);
            }
        });
    }

    private void impl(Operation operation) {
        Type type;
        PathBuilder builder;
        List<UriPart> parts = UriPart.parts(operation.getUri());
        if (parts.get((int)0).variable) {
            Parameter parameter = ServiceWriter.pathVariableParameter(operation, parts.get((int)0).text);
            this.code("let _uri = encodeURIComponent(options.").code(parameter.getName()).codeIf(parameter.getType() instanceof ArrayType, ".join(',')").code(");\n");
        } else {
            this.code("let _uri = '").code(parts.get((int)0).text).code("';\n");
        }
        for (int i = 1; i < parts.size(); ++i) {
            if (parts.get((int)i).variable) {
                Parameter parameter = ServiceWriter.pathVariableParameter(operation, parts.get((int)i).text);
                this.code("_uri += encodeURIComponent(options.").code(parameter.getName()).codeIf(parameter.getType() instanceof ArrayType, ".join(',')").code(");\n");
                continue;
            }
            this.code("_uri += '").code(parts.get((int)i).text).code("';\n");
        }
        LinkedHashMap<String, PathBuilder> pathBuilderMap = new LinkedHashMap<String, PathBuilder>();
        for (Parameter parameter : operation.getParameters()) {
            if (parameter.getPathVariable() != null || parameter.getRequestParam() != null || parameter.isRequestBody()) continue;
            builder = new PathBuilder();
            builder.dot().append(parameter.getName());
            type = parameter.getType();
            if (type instanceof NullableType) {
                builder.nullable();
                type = ((NullableType)type).getTargetType();
            }
            if (type instanceof ArrayType) {
                builder.dot().append("join(',')");
                pathBuilderMap.put(parameter.getName(), builder);
                continue;
            }
            if (type instanceof SimpleType) {
                pathBuilderMap.put(parameter.getName(), builder);
                continue;
            }
            if (!(type instanceof ObjectType)) continue;
            for (Property prop : ((ObjectType)type).getProperties().values()) {
                PathBuilder newBuilder = new PathBuilder(builder);
                newBuilder.dot().append(prop.getName());
                Type newType = prop.getType();
                if (newType instanceof NullableType) {
                    newBuilder.nullable();
                    newType = ((NullableType)newType).getTargetType();
                }
                if (newType instanceof ArrayType) {
                    newBuilder.dot().append("join(',')");
                    pathBuilderMap.put(prop.getName(), newBuilder);
                    continue;
                }
                if (!(newType instanceof SimpleType)) continue;
                pathBuilderMap.put(prop.getName(), newBuilder);
            }
        }
        for (Parameter parameter : operation.getParameters()) {
            if (parameter.getRequestParam() == null) continue;
            builder = new PathBuilder();
            builder.dot().append(parameter.getName());
            type = parameter.getType();
            if (type instanceof NullableType) {
                builder.nullable();
                type = ((NullableType)type).getTargetType();
            }
            if (type instanceof ArrayType) {
                builder.dot().append("join(',')");
                pathBuilderMap.put(parameter.getName(), builder);
                continue;
            }
            if (!(type instanceof SimpleType) && !(type instanceof EnumType)) continue;
            pathBuilderMap.put(parameter.getName(), builder);
        }
        if (!pathBuilderMap.isEmpty()) {
            this.code("let _separator = _uri.indexOf('?') === -1 ? '?' : '&';\n");
            this.code("let _value: any = undefined;\n");
            for (Map.Entry entry : pathBuilderMap.entrySet()) {
                builder = (PathBuilder)entry.getValue();
                this.code("_value = options").code(builder.toString()).code(";\n");
                this.code("if (_value !== undefined && _value !== null) ");
                this.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
                    this.code("_uri += _separator\n");
                    this.code("_uri += '").code((String)e.getKey() + "=").code("'\n");
                    this.code("_uri += encodeURIComponent(_value);\n");
                    this.code("_separator = '&';\n");
                });
                this.code("\n");
            }
        }
        this.code("return (await this.executor({uri: _uri, method: '").code(operation.getHttpMethod().name()).code("'");
        for (Parameter parameter : operation.getParameters()) {
            if (!parameter.isRequestBody()) continue;
            this.code(", body: options.").code(parameter.getName());
        }
        this.code("})) as ").typeRef(operation.getType());
    }

    private static Parameter pathVariableParameter(Operation operation, String pathVariable) {
        for (Parameter parameter : operation.getParameters()) {
            if (!pathVariable.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new IllegalDocMetaException("Illegal operation \"" + operation.getRawMethod() + "\", the path variable {" + pathVariable + "} cannot be resolved by any parameter");
    }

    @Override
    protected boolean rawImmutableAsDynamic() {
        return true;
    }

    private static class UriPart {
        private static final Pattern SLASH_PATTERN = Pattern.compile("\\{[^\\}]+\\}");
        final String text;
        final boolean variable;

        private UriPart(String text, boolean variable) {
            this.text = text;
            this.variable = variable;
        }

        public static List<UriPart> parts(String uri) {
            if (!uri.startsWith("/")) {
                uri = '/' + uri;
            }
            ArrayList<UriPart> uriParts = new ArrayList<UriPart>();
            Matcher matcher = SLASH_PATTERN.matcher(uri);
            int pos = 0;
            while (matcher.find()) {
                if (matcher.start() > pos) {
                    uriParts.add(new UriPart(uri.substring(pos, matcher.start()), false));
                }
                uriParts.add(new UriPart(uri.substring(matcher.start() + 1, matcher.end() - 1), true));
                pos = matcher.end();
            }
            if (pos < uri.length()) {
                uriParts.add(new UriPart(uri.substring(pos, uri.length()), false));
            }
            return uriParts;
        }
    }

    private static class PathBuilder {
        private final StringBuilder builder;
        private boolean nullable;

        PathBuilder() {
            this.builder = new StringBuilder();
        }

        PathBuilder(PathBuilder base) {
            this.builder = new StringBuilder(base.builder);
            this.nullable = base.nullable;
        }

        public PathBuilder nullable() {
            this.nullable = true;
            return this;
        }

        public PathBuilder dot() {
            if (this.nullable) {
                this.builder.append("?.");
            } else {
                this.builder.append('.');
            }
            return this;
        }

        public PathBuilder append(String text) {
            int size = text.length();
            for (int i = 0; i < size; ++i) {
                char c = text.charAt(i);
                if (this.nullable && c == '.') {
                    this.builder.append("?.");
                    continue;
                }
                this.builder.append(c);
            }
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

