/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.EnumType;
import org.babyfish.jimmer.client.meta.Visitor;

public class EnumTypeImpl
implements EnumType {
    private final Class<?> javaType;
    private List<String> items;

    public EnumTypeImpl(Class<?> javaType) {
        Enum[] values;
        Method method;
        this.javaType = javaType;
        try {
            method = javaType.getMethod("values", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new AssertionError("Internal bug", ex);
        }
        try {
            values = (Enum[])method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError("Internal bug", ex);
        }
        catch (InvocationTargetException ex) {
            throw new AssertionError("Internal bug", ex.getTargetException());
        }
        this.items = Collections.unmodifiableList(Arrays.stream(values).map(Enum::name).collect(Collectors.toList()));
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public List<String> getItems() {
        return this.items;
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.isTypeVisitable(this)) {
            visitor.visitEnumType(this);
        }
    }

    public String toString() {
        return this.items.stream().collect(Collectors.joining(" | "));
    }
}

