/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.java.feign;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.babyfish.jimmer.client.generator.File;
import org.babyfish.jimmer.client.generator.Generator;
import org.babyfish.jimmer.client.generator.GeneratorException;
import org.babyfish.jimmer.client.generator.java.DtoWriter;
import org.babyfish.jimmer.client.generator.java.JavaContext;
import org.babyfish.jimmer.client.generator.java.TypeDefinitionWriter;
import org.babyfish.jimmer.client.generator.java.feign.ServiceWriter;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Node;
import org.babyfish.jimmer.client.meta.Service;
import org.babyfish.jimmer.client.meta.Type;

public class JavaFeignGenerator
implements Generator {
    private final String feignClientName;
    private final int indent;
    private final String basePackage;

    public JavaFeignGenerator(String feignClientName, int indent, String basePackage) {
        this.feignClientName = feignClientName;
        this.indent = indent;
        this.basePackage = basePackage;
    }

    @Override
    public void generate(Metadata metadata, OutputStream out) {
        try {
            ZipOutputStream zipOut = new ZipOutputStream(out);
            this.generate0(new JavaContext(metadata, zipOut, this.feignClientName, this.indent, this.basePackage), zipOut);
            zipOut.finish();
        }
        catch (IOException | Error | RuntimeException ex) {
            throw new GeneratorException(ex);
        }
    }

    private void generate0(JavaContext ctx, ZipOutputStream zipOut) throws IOException {
        File file;
        String baseDir = ctx.getBasePackage().isEmpty() ? "" : ctx.getBasePackage().replace('.', '/') + '/';
        for (Map.Entry<Service, File> entry : ctx.getServiceFileMap().entrySet()) {
            Service service = entry.getKey();
            file = entry.getValue();
            JavaFeignGenerator.putEntry(zipOut, baseDir + file + ".java");
            new ServiceWriter(ctx, service).flush();
            zipOut.closeEntry();
        }
        for (Map.Entry<Node, File> entry : ctx.getTypeFilePairs()) {
            Type type = (Type)entry.getKey();
            file = entry.getValue();
            JavaFeignGenerator.putEntry(zipOut, baseDir + file + ".java");
            new TypeDefinitionWriter(ctx, type).flush();
            zipOut.closeEntry();
        }
        for (Map.Entry<Object, Object> entry : ctx.getDtoMap().entrySet()) {
            Class rawType = (Class)entry.getKey();
            DtoWriter dtoWriter = new DtoWriter(ctx, rawType);
            JavaFeignGenerator.putEntry(zipOut, baseDir + dtoWriter.getFile() + ".java");
            dtoWriter.flush();
            zipOut.closeEntry();
        }
    }

    private static void putEntry(ZipOutputStream zipOut, String fileName) throws IOException {
        if (fileName.charAt(0) == '/') {
            fileName = fileName.substring(1);
        }
        zipOut.putNextEntry(new ZipEntry(fileName));
    }
}

